"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewHost = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _overview_host = require("../../containers/overview_host");
var _header_section = require("../../../common/components/header_section");
var _kibana = require("../../../common/lib/kibana");
var _overview_host_stats = require("../overview_host_stats");
var _manage_query = require("../../../common/components/page/manage_query");
var _inspect = require("../../../common/components/inspect");
var _links = require("../../../common/components/links");
var _types = require("../../../app/types");
var _query_toggle = require("../../../common/containers/query_toggle");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewHostStatsManage = (0, _manage_query.manageQuery)(_overview_host_stats.OverviewHostStats);
const OverviewHostComponent = ({
  endDate,
  filterQuery,
  indexNames,
  startDate,
  setQuery
}) => {
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(_overview_host.ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(filterQuery === undefined || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(filterQuery === undefined || !toggleStatus);
  }, [filterQuery, toggleStatus]);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
    // toggle on = skipQuery false
    setQuerySkip(!status);
  }, [setQuerySkip, setToggleStatus]);
  const [loading, {
    overviewHost,
    id,
    inspect,
    refetch
  }] = (0, _overview_host.useHostOverview)({
    endDate,
    filterQuery,
    indexNames,
    startDate,
    skip: querySkip
  });
  const hostEventsCount = (0, _react.useMemo)(() => (0, _overview_host_stats.getOverviewHostStats)(overviewHost).reduce((total, stat) => total + stat.count, 0), [overviewHost]);
  const formattedHostEventsCount = (0, _react.useMemo)(() => (0, _numeral.default)(hostEventsCount).format(defaultNumberFormat), [defaultNumberFormat, hostEventsCount]);
  const title = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostsTitle",
    defaultMessage: "Host events"
  }), []);
  const subtitle = (0, _react.useMemo)(() => !(0, _fp.isEmpty)(overviewHost) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Showing: {formattedHostEventsCount} {hostEventsCount, plural, one {event} other {events}}",
    id: "xpack.securitySolution.overview.overviewHost.hostsSubtitle",
    values: {
      hostEventsCount,
      formattedHostEventsCount
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ''), [formattedHostEventsCount, hostEventsCount, overviewHost]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: toggleStatus
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: _overview_host.ID,
    subtitle: subtitle,
    toggleStatus: toggleStatus,
    toggleQuery: toggleQuery,
    title: title,
    isInspectDisabled: filterQuery === undefined
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    deepLinkId: _types.SecurityPageName.hosts
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostsAction",
    defaultMessage: "View hosts"
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(OverviewHostStatsManage, {
    loading: loading,
    data: overviewHost,
    setQuery: setQuery,
    id: id,
    inspect: inspect,
    refetch: refetch
  })));
};
OverviewHostComponent.displayName = 'OverviewHostComponent';
const OverviewHost = /*#__PURE__*/_react.default.memo(OverviewHostComponent);
exports.OverviewHost = OverviewHost;