"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.REGION = exports.PLATFORM = exports.OS = exports.MAX_ANOMALY_SCORE_BY_JOB = exports.MAC_ADDRESSES = exports.MACHINE_TYPE = exports.LAST_SEEN = exports.IP_ADDRESSES = exports.INSTANCE_ID = exports.INSPECT_TITLE = exports.HOST_RISK_SCORE = exports.HOST_RISK_CLASSIFICATION = exports.HOST_ID = exports.FIRST_SEEN = exports.FAMILY = exports.CLOUD_PROVIDER = exports.ARCHITECTURE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_ID = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.hostIdTitle', {
  defaultMessage: 'Host ID'
});
exports.HOST_ID = HOST_ID;
const FIRST_SEEN = _i18n.i18n.translate('xpack.securitySolution.host.details.firstSeenTitle', {
  defaultMessage: 'First seen'
});
exports.FIRST_SEEN = FIRST_SEEN;
const LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.host.details.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
exports.LAST_SEEN = LAST_SEEN;
const MAX_ANOMALY_SCORE_BY_JOB = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.maxAnomalyScoreByJobTitle', {
  defaultMessage: 'Max anomaly score by job'
});
exports.MAX_ANOMALY_SCORE_BY_JOB = MAX_ANOMALY_SCORE_BY_JOB;
const HOST_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.hostRiskScoreTitle', {
  defaultMessage: 'Host risk score'
});
exports.HOST_RISK_SCORE = HOST_RISK_SCORE;
const HOST_RISK_CLASSIFICATION = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.hostRiskClassification', {
  defaultMessage: 'Host risk classification'
});
exports.HOST_RISK_CLASSIFICATION = HOST_RISK_CLASSIFICATION;
const IP_ADDRESSES = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.ipAddressesTitle', {
  defaultMessage: 'IP addresses'
});
exports.IP_ADDRESSES = IP_ADDRESSES;
const MAC_ADDRESSES = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.macAddressesTitle', {
  defaultMessage: 'MAC addresses'
});
exports.MAC_ADDRESSES = MAC_ADDRESSES;
const PLATFORM = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.platformTitle', {
  defaultMessage: 'Platform'
});
exports.PLATFORM = PLATFORM;
const OS = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.osTitle', {
  defaultMessage: 'Operating system'
});
exports.OS = OS;
const FAMILY = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.familyTitle', {
  defaultMessage: 'Family'
});
exports.FAMILY = FAMILY;
const VERSION = _i18n.i18n.translate('xpack.securitySolution.host.details.versionLabel', {
  defaultMessage: 'Version'
});
exports.VERSION = VERSION;
const ARCHITECTURE = _i18n.i18n.translate('xpack.securitySolution.host.details.architectureLabel', {
  defaultMessage: 'Architecture'
});
exports.ARCHITECTURE = ARCHITECTURE;
const CLOUD_PROVIDER = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.cloudProviderTitle', {
  defaultMessage: 'Cloud provider'
});
exports.CLOUD_PROVIDER = CLOUD_PROVIDER;
const REGION = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.regionTitle', {
  defaultMessage: 'Region'
});
exports.REGION = REGION;
const INSTANCE_ID = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.instanceIdTitle', {
  defaultMessage: 'Instance ID'
});
exports.INSTANCE_ID = INSTANCE_ID;
const MACHINE_TYPE = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.machineTypeTitle', {
  defaultMessage: 'Machine type'
});
exports.MACHINE_TYPE = MACHINE_TYPE;
const INSPECT_TITLE = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.inspectTitle', {
  defaultMessage: 'Host overview'
});
exports.INSPECT_TITLE = INSPECT_TITLE;