"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityInfo = void 0;
var _reactRedux = require("react-redux");
var _redirect_to_users = require("../../../../common/components/link_to/redirect_to_users");
var _model = require("../../../../explore/users/store/model");
var _redirect_to_hosts = require("../../../../common/components/link_to/redirect_to_hosts");
var _model2 = require("../../../../explore/hosts/store/model");
var _risk_score = require("../../../../../common/search_strategy/security_solution/risk_score");
var _store = require("../../../../explore/users/store");
var _constants = require("../../../../../common/constants");
var _store2 = require("../../../../explore/hosts/store");
var _types = require("../../../../app/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_RISK_TABLE_QUERY_ID = 'hostRiskDashboardTable';
const HOST_RISK_KPI_QUERY_ID = 'headerHostRiskScoreKpiQuery';
const USER_RISK_TABLE_QUERY_ID = 'userRiskDashboardTable';
const USER_RISK_KPI_QUERY_ID = 'headerUserRiskScoreKpiQuery';
const useEntityInfo = riskEntity => {
  const dispatch = (0, _reactRedux.useDispatch)();
  return riskEntity === _risk_score.RiskScoreEntity.host ? {
    docLink: _constants.RISKY_HOSTS_DOC_LINK,
    linkProps: {
      deepLinkId: _types.SecurityPageName.hosts,
      path: (0, _redirect_to_hosts.getTabsOnHostsUrl)(_model2.HostsTableType.risk),
      onClick: () => {
        dispatch(_store2.hostsActions.updateHostRiskScoreSeverityFilter({
          severitySelection: [],
          hostsType: _model2.HostsType.page
        }));
      }
    },
    tableQueryId: HOST_RISK_TABLE_QUERY_ID,
    kpiQueryId: HOST_RISK_KPI_QUERY_ID
  } : {
    docLink: _constants.RISKY_USERS_DOC_LINK,
    linkProps: {
      deepLinkId: _types.SecurityPageName.users,
      path: (0, _redirect_to_users.getTabsOnUsersUrl)(_model.UsersTableType.risk),
      onClick: () => {
        dispatch(_store.usersActions.updateUserRiskScoreSeverityFilter({
          severitySelection: []
        }));
      }
    },
    tableQueryId: USER_RISK_TABLE_QUERY_ID,
    kpiQueryId: USER_RISK_KPI_QUERY_ID
  };
};
exports.useEntityInfo = useEntityInfo;