"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var _risk_score_donut = require("../../../../common/components/visualization_actions/lens_attributes/common/risk_scores/risk_score_donut");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _helpers = require("../../../../explore/hosts/store/helpers");
var _risk_score_donut_chart = require("../common/risk_score_donut_chart");
var _translations = require("../common/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CHART_HEIGHT = 180;
const ChartContentComponent = ({
  dataExists,
  kpiQueryId,
  riskEntity,
  severityCount,
  timerange,
  selectedSeverity
}) => {
  const isDonutChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('donutChartEmbeddablesEnabled');
  const spaceId = (0, _use_space_id.useSpaceId)();
  const extraOptions = (0, _react.useMemo)(() => ({
    spaceId,
    filters: (0, _helpers.generateSeverityFilter)(selectedSeverity, riskEntity)
  }), [spaceId, selectedSeverity, riskEntity]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDonutChartEmbeddablesEnabled && spaceId && dataExists && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    donutTextWrapperClassName: "risk-score",
    extraOptions: extraOptions,
    getLensAttributes: _risk_score_donut.getRiskScoreDonutAttributes,
    height: CHART_HEIGHT,
    id: `${kpiQueryId}-donut`,
    isDonut: true,
    label: _translations.TOTAL_LABEL,
    stackByField: riskEntity,
    timerange: timerange,
    width: "270px"
  }), !isDonutChartEmbeddablesEnabled && /*#__PURE__*/_react.default.createElement(_risk_score_donut_chart.RiskScoreDonutChart, {
    severityCount: severityCount !== null && severityCount !== void 0 ? severityCount : _search_strategy.EMPTY_SEVERITY_COUNT
  }));
};
const ChartContent = /*#__PURE__*/_react.default.memo(ChartContentComponent);
exports.ChartContent = ChartContent;