"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskDonutChartData = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _common = require("../../../../explore/components/risk_score/severity/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const legendField = 'kibana.alert.severity';
const useRiskDonutChartData = severityCount => {
  const [donutChartData, legendItems, total] = (0, _react.useMemo)(() => {
    const severities = Object.keys(_common.RISK_SEVERITY_COLOUR);
    return [severities.map(status => ({
      key: status,
      value: severityCount[status]
    })), severities.map(status => ({
      color: _common.RISK_SEVERITY_COLOUR[status],
      field: legendField,
      value: status
    })), (0, _fp.sum)(Object.values(severityCount))];
  }, [severityCount]);
  return [donutChartData, legendItems, total];
};
exports.useRiskDonutChartData = useRiskDonutChartData;