"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalAnomalies = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../../../../../common/machine_learning/helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _anomalies_tab_link = require("./anomalies_tab_link");
var _enable_job = require("./enable_job");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TotalAnomalies = ({
  count,
  job,
  entity,
  recentlyEnabledJobIds,
  loading,
  onJobEnabled
}) => {
  if ((0, _helpers.isJobLoading)(job.jobState, job.datafeedState)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.JOB_STATUS_WAITING);
  } else if ((0, _helpers.isJobFailed)(job.jobState, job.datafeedState)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.JOB_STATUS_FAILED);
  } else if (count > 0 || (0, _helpers.isJobStarted)(job.jobState, job.datafeedState) || recentlyEnabledJobIds.includes(job.id)) {
    return /*#__PURE__*/_react.default.createElement(_anomalies_tab_link.AnomaliesTabLink, {
      count: count,
      jobId: job.id,
      entity: entity
    });
  } else if (job.isCompatible) {
    return /*#__PURE__*/_react.default.createElement(_enable_job.EnableJob, {
      job: job,
      isLoading: loading,
      onJobEnabled: onJobEnabled
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": "Warning",
      size: "s",
      type: "warning",
      color: "warning"
    });
  }
};
exports.TotalAnomalies = TotalAnomalies;