"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableColumns = exports.RuleAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _cellActions = require("@kbn/cell-actions");
var _constants = require("../../../../actions/constants");
var _use_navigate_to_alerts_page_with_filters = require("../../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _header_section = require("../../../../common/components/header_section");
var _utils = require("../utils");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_rule_alerts_items = require("./use_rule_alerts_items");
var _kibana = require("../../../../common/lib/kibana");
var _constants2 = require("../../../../../common/constants");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _hover_visibility_container = require("../../../../common/components/hover_visibility_container");
var _inspect = require("../../../../common/components/inspect");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _formatted_number = require("../../../../common/components/formatted_number");
var _cell_actions = require("../../../../common/components/cell_actions");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID = 'detection-response-rule-alerts-severity-table';
const getTableColumns = ({
  getAppUrl,
  navigateTo,
  openRuleInAlertsPage
}) => [{
  field: 'name',
  name: i18n.RULE_ALERTS_COLUMN_RULE_NAME,
  render: (name, {
    id
  }) => {
    const url = getAppUrl({
      deepLinkId: _constants2.SecurityPageName.rules,
      path: `id/${id}`
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": `${id}-tooltip`,
      title: i18n.OPEN_RULE_DETAIL_TOOLTIP,
      content: name,
      anchorClassName: "eui-textTruncate"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "severityRuleAlertsTable-name",
      href: url,
      onClick: ev => {
        if (ev) {
          ev.preventDefault();
        }
        navigateTo({
          url
        });
      }
    }, name));
  }
}, {
  field: 'last_alert_at',
  name: i18n.RULE_ALERTS_COLUMN_LAST_ALERT,
  'data-test-subj': 'severityRuleAlertsTable-lastAlertAt',
  render: lastAlertAt => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
    value: new Date(lastAlertAt)
  })
}, {
  field: 'alert_count',
  name: i18n.RULE_ALERTS_COLUMN_ALERT_COUNT,
  'data-test-subj': 'severityRuleAlertsTable-alertCount',
  render: (alertCount, {
    name
  }) => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    field: {
      name: _ruleDataUtils.ALERT_RULE_NAME,
      value: name,
      type: 'keyword',
      aggregatable: true
    },
    mode: _cellActions.CellActionsMode.HOVER_RIGHT,
    triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
    metadata: {
      andFilters: [{
        field: 'kibana.alert.workflow_status',
        value: 'open'
      }]
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "severityRuleAlertsTable-alertCountLink",
    disabled: alertCount === 0,
    onClick: () => openRuleInAlertsPage(name)
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: alertCount
  })))
}, {
  field: 'severity',
  name: i18n.RULE_ALERTS_COLUMN_SEVERITY,
  'data-test-subj': 'severityRuleAlertsTable-severity',
  render: severity => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: _utils.SEVERITY_COLOR[severity]
  }, (0, _lodash.capitalize)(severity))
}];
exports.getTableColumns = getTableColumns;
const RuleAlertsTable = /*#__PURE__*/_react.default.memo(({
  signalIndexName
}) => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID);
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const {
    items,
    isLoading,
    updatedAt
  } = (0, _use_rule_alerts_items.useRuleAlertsItems)({
    signalIndexName,
    queryId: DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID,
    skip: !toggleStatus,
    filterQuery
  });
  const openAlertsPageWithFilter = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const openRuleInAlertsPage = (0, _react.useCallback)(ruleName => openAlertsPageWithFilter({
    title: i18n.OPEN_IN_ALERTS_TITLE_RULENAME,
    selectedOptions: [ruleName],
    fieldName: _ruleDataUtils.ALERT_RULE_NAME
  }), [openAlertsPageWithFilter]);
  const navigateToAlerts = (0, _react.useCallback)(() => {
    openAlertsPageWithFilter({
      title: i18n.OPEN_IN_ALERTS_TITLE_STATUS,
      selectedOptions: ['open'],
      fieldName: _ruleDataUtils.ALERT_WORKFLOW_STATUS
    });
  }, [openAlertsPageWithFilter]);
  const columns = (0, _react.useMemo)(() => getTableColumns({
    getAppUrl,
    navigateTo,
    openRuleInAlertsPage
  }), [getAppUrl, navigateTo, openRuleInAlertsPage]);
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "severityRuleAlertsPanel"
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID,
    title: i18n.RULE_ALERTS_SECTION_TITLE,
    titleSize: "s",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading
    })
  }), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "severityRuleAlertsTable",
    columns: columns,
    items: items,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", null, i18n.NO_ALERTS_FOUND),
      titleSize: "xs"
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "severityRuleAlertsButton",
    onClick: navigateToAlerts
  }, i18n.OPEN_ALL_ALERTS_BUTTON))));
});
exports.RuleAlertsTable = RuleAlertsTable;
RuleAlertsTable.displayName = 'RuleAlertsTable';