"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrustedAppsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _service = require("../service");
var _form = require("./components/form");
var _constants = require("../constants");
var _artifacts_docs_link = require("./components/artifacts_docs_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRUSTED_APPS_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.pageTitle', {
    defaultMessage: 'Trusted applications'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.trustedApps.pageAboutInfo', {
    defaultMessage: 'Add a trusted application to improve performance or alleviate conflicts with other applications running on your hosts. Trusted applications may still generate alerts in some cases.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.pageAddButtonTitle', {
    defaultMessage: 'Add trusted application'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.trustedApps.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {trusted application} other {trusted applications}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.cardActionEditLabel', {
    defaultMessage: 'Edit trusted application'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.cardActionDeleteLabel', {
    defaultMessage: 'Delete trusted application'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutCreateTitle', {
    defaultMessage: 'Add trusted application'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutEditTitle', {
    defaultMessage: 'Edit trusted application'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add trusted application'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your trusted applications.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedApps.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our "
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.trustedApps}`
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedApps.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "Trusted applications documentation"
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.trustedApps.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from trusted applications.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no trusted applications to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStateTitle', {
    defaultMessage: 'Add your first trusted application'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStateInfo', {
    defaultMessage: 'Add a trusted application to improve performance or alleviate conflicts with other applications running on your hosts. Trusted applications may still generate alerts in some cases.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add trusted application'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.trustedApps.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, value'
  })
};
const TrustedAppsList = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteTrustedApplications
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const trustedAppsApiClient = _service.TrustedAppsApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: trustedAppsApiClient,
    ArtifactFormComponent: _form.TrustedAppsForm,
    labels: TRUSTED_APPS_PAGE_LABELS,
    "data-test-subj": "trustedAppsListPage",
    searchableFields: _constants.SEARCHABLE_FIELDS,
    secondaryPageInfo: /*#__PURE__*/_react.default.createElement(_artifacts_docs_link.TrustedAppsArtifactsDocsLink, null),
    allowCardDeleteAction: canWriteTrustedApplications,
    allowCardEditAction: canWriteTrustedApplications,
    allowCardCreateAction: canWriteTrustedApplications
  });
});
exports.TrustedAppsList = TrustedAppsList;
TrustedAppsList.displayName = 'TrustedAppsList';