"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.POLICY_ARTIFACT_EVENT_FILTERS_LABELS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLICY_ARTIFACT_EVENT_FILTERS_LABELS = Object.freeze({
  deleteModalTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.list.removeDialog.title', {
    defaultMessage: 'Remove event filter from policy'
  }),
  deleteModalImpactInfo: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.list.removeDialog.messageCallout', {
    defaultMessage: 'This event filter will be removed only from this policy and can still be found and managed from the artifact page.'
  }),
  deleteModalErrorMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.list.removeDialog.errorToastTitle', {
    defaultMessage: 'Error while attempting to remove event filter'
  }),
  flyoutWarningCalloutMessage: maxNumber => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.flyout.searchWarning.text', {
    defaultMessage: 'Only the first {maxNumber} event filters are displayed. Please use the search bar to refine the results.',
    values: {
      maxNumber
    }
  }),
  flyoutNoArtifactsToBeAssignedMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.flyout.noAssignable', {
    defaultMessage: 'There are no event filters that can be assigned to this policy.'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.flyout.title', {
    defaultMessage: 'Assign event filters'
  }),
  flyoutSubtitle: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.flyout.subtitle', {
    defaultMessage: 'Select event filters to add to {policyName}',
    values: {
      policyName
    }
  }),
  flyoutSearchPlaceholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.search.label', {
    defaultMessage: 'Search event filters'
  }),
  flyoutErrorMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.flyout.toastError.text', {
    defaultMessage: `An error occurred updating event filters`
  }),
  flyoutSuccessMessageText: updatedExceptions => updatedExceptions.length > 1 ? _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.flyout.toastSuccess.textMultiples', {
    defaultMessage: '{count} event filters have been added to your list.',
    values: {
      count: updatedExceptions.length
    }
  }) : _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.flyout.toastSuccess.textSingle', {
    defaultMessage: '"{name}" has been added to your event filter list.',
    values: {
      name: updatedExceptions[0].name
    }
  }),
  emptyUnassignedTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unassigned.title', {
    defaultMessage: 'No assigned event filters'
  }),
  emptyUnassignedMessage: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unassigned.content', {
    defaultMessage: 'There are currently no event filters assigned to {policyName}. Assign event filters now or add and manage them on the event filters page.',
    values: {
      policyName
    }
  }),
  emptyUnassignedPrimaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unassigned.primaryAction', {
    defaultMessage: 'Assign event filters'
  }),
  emptyUnassignedSecondaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unassigned.secondaryAction', {
    defaultMessage: 'Manage event filters'
  }),
  emptyUnassignedNoPrivilegesMessage: policyName => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unassigned.noPrivileges.content', {
    defaultMessage: 'There are currently no event filters assigned to {policyName}',
    values: {
      policyName
    }
  }),
  emptyUnexistingTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unexisting.title', {
    defaultMessage: 'No event filters exist'
  }),
  emptyUnexistingMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unexisting.content', {
    defaultMessage: 'There are currently no event filters applied to your endpoints.'
  }),
  emptyUnexistingPrimaryActionButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.empty.unexisting.action', {
    defaultMessage: 'Add event filters'
  }),
  listTotalItemCountMessage: totalItemsCount => _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.list.totalItemCount', {
    defaultMessage: 'Showing {totalItemsCount, plural, one {# event filter} other {# event filters}}',
    values: {
      totalItemsCount
    }
  }),
  listRemoveActionNotAllowedMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.list.removeActionNotAllowed', {
    defaultMessage: 'Globally applied event filter cannot be removed from policy.'
  }),
  listSearchPlaceholderMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.list.search.placeholder', {
    defaultMessage: `Search on the fields below: name, description, comments, value`
  }),
  layoutTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.title', {
    defaultMessage: 'Assigned event filters'
  }),
  layoutAssignButtonTitle: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.assignToPolicy', {
    defaultMessage: 'Assign event filters to policy'
  }),
  layoutViewAllLinkMessage: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventFilters.layout.about.viewAllLinkLabel', {
    defaultMessage: 'view all event filters'
  })
});
exports.POLICY_ARTIFACT_EVENT_FILTERS_LABELS = POLICY_ARTIFACT_EVENT_FILTERS_LABELS;