"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsPolicySettingsBarVisible = void 0;
exports.usePolicyDetailsArtifactsNavigateCallback = usePolicyDetailsArtifactsNavigateCallback;
exports.usePolicyDetailsSelector = usePolicyDetailsSelector;
exports.useShowEditableFormFields = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _kibana = require("../../../../common/lib/kibana");
var _user_privileges = require("../../../../common/components/user_privileges");
var _constants = require("../../../common/constants");
var _routing = require("../../../common/routing");
var _selectors = require("../store/policy_details/selectors");
var _constants2 = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Narrows global state down to the PolicyDetailsState before calling the provided Policy Details Selector
 * @param selector
 */
function usePolicyDetailsSelector(selector) {
  return (0, _reactRedux.useSelector)(state => selector(state[_constants.MANAGEMENT_STORE_GLOBAL_NAMESPACE][_constants.MANAGEMENT_STORE_POLICY_DETAILS_NAMESPACE]));
}
function usePolicyDetailsArtifactsNavigateCallback(listId) {
  const location = usePolicyDetailsSelector(_selectors.getCurrentArtifactsLocation);
  const history = (0, _reactRouterDom.useHistory)();
  const policyId = usePolicyDetailsSelector(_selectors.policyIdFromParams);
  const {
    state
  } = (0, _reactRouterDom.useLocation)();
  const getPath = (0, _react.useCallback)(args => {
    if (listId === _securitysolutionListConstants.ENDPOINT_TRUSTED_APPS_LIST_ID) {
      return (0, _routing.getPolicyDetailsArtifactsListPath)(policyId, {
        ...location,
        ...args
      });
    } else if (listId === _securitysolutionListConstants.ENDPOINT_EVENT_FILTERS_LIST_ID) {
      return (0, _routing.getPolicyEventFiltersPath)(policyId, {
        ...location,
        ...args
      });
    } else if (listId === _securitysolutionListConstants.ENDPOINT_BLOCKLISTS_LIST_ID) {
      return (0, _routing.getPolicyBlocklistsPath)(policyId, {
        ...location,
        ...args
      });
    } else {
      return (0, _routing.getPolicyHostIsolationExceptionsPath)(policyId, {
        ...location,
        ...args
      });
    }
  }, [listId, location, policyId]);
  return (0, _react.useCallback)(args => history.push(getPath(args), state), [getPath, history, state]);
}
const useIsPolicySettingsBarVisible = () => {
  return window.location.pathname.includes(_constants2.POLICIES_PATH) && window.location.pathname.includes('/settings');
};

/**
 * Indicates if user is granted Write access to Policy Management. This method differs from what
 * `useUserPrivileges().endpointPrivileges.canWritePolicyManagement` in that it also checks if
 * user has `canAccessFleet` if form is being displayed outside of Security Solution.
 * This is to ensure that the Policy Form remains accessible when displayed inside of Fleet
 * pages if the user does not have privileges to security solution policy management.
 */
exports.useIsPolicySettingsBarVisible = useIsPolicySettingsBarVisible;
const useShowEditableFormFields = () => {
  const {
    canWritePolicyManagement,
    canAccessFleet
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    getUrlForApp
  } = (0, _kibana.useKibana)().services.application;
  const securitySolutionUrl = (0, _react.useMemo)(() => {
    return getUrlForApp(_constants2.APP_UI_ID);
  }, [getUrlForApp]);
  return (0, _react.useMemo)(() => {
    if (window.location.pathname.startsWith(securitySolutionUrl)) {
      return canWritePolicyManagement;
    } else {
      return canAccessFleet;
    }
  }, [canAccessFleet, canWritePolicyManagement, securitySolutionUrl]);
};
exports.useShowEditableFormFields = useShowEditableFormFields;