"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MalwareProtections = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _constants = require("../../../../../../../common/constants");
var _types = require("../../../../../../app/types");
var _types2 = require("../../../../../../../common/endpoint/types");
var _config_form = require("../../components/config_form");
var _link_to_app = require("../../../../../../common/components/endpoint/link_to_app");
var _use_license = require("../../../../../../common/hooks/use_license");
var _radio_buttons = require("../components/radio_buttons");
var _user_notification = require("../components/user_notification");
var _protection_switch = require("../components/protection_switch");
var _selectors = require("../../../store/policy_details/selectors");
var _policy_hooks = require("../../policy_hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** The Malware Protections form for policy details
 *  which will configure for all relevant OSes.
 */
const MalwareProtections = /*#__PURE__*/_react.default.memo(() => {
  const OSes = (0, _react.useMemo)(() => [_types2.PolicyOperatingSystem.windows, _types2.PolicyOperatingSystem.mac, _types2.PolicyOperatingSystem.linux], []);
  const protection = 'malware';
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.malware', {
    defaultMessage: 'Malware protections'
  });
  const blocklistLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.blocklist', {
    defaultMessage: 'Blocklist enabled'
  });
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const dispatch = (0, _reactRedux.useDispatch)();
  const policyDetailsConfig = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyConfig);
  const blocklistUpdate = ({
    value,
    policyConfigData,
    protectionOsList
  }) => {
    const newPayload = (0, _lodash.cloneDeep)(policyConfigData);
    for (const os of protectionOsList) {
      newPayload[os][protection].blocklist = value;
    }
    return newPayload;
  };
  const handleBlocklistSwitchChange = (0, _react.useCallback)(event => {
    if (policyDetailsConfig) {
      const newPayload = blocklistUpdate({
        value: event.target.checked,
        policyConfigData: (0, _lodash.cloneDeep)(policyDetailsConfig),
        protectionOsList: OSes
      });
      dispatch({
        type: 'userChangedPolicyConfig',
        payload: {
          policyConfig: newPayload
        }
      });
    }
  }, [dispatch, OSes, policyDetailsConfig]);
  return /*#__PURE__*/_react.default.createElement(_config_form.ConfigForm, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.malware', {
      defaultMessage: 'Malware'
    }),
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC, _securitysolutionUtils.OperatingSystem.LINUX],
    dataTestSubj: "malwareProtectionsForm",
    rightCorner: /*#__PURE__*/_react.default.createElement(_protection_switch.ProtectionSwitch, {
      protection: protection,
      protectionLabel: protectionLabel,
      osList: OSes,
      additionalOnSwitchChange: blocklistUpdate
    })
  }, /*#__PURE__*/_react.default.createElement(_radio_buttons.RadioButtons, {
    protection: protection,
    osList: OSes
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: blocklistLabel,
    checked: policyDetailsConfig.windows[protection].blocklist,
    onChange: handleBlocklistSwitchChange,
    disabled: !showEditableFormFields || policyDetailsConfig.windows[protection].mode === 'off'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.blocklistTooltip",
      defaultMessage: "Enables or disables the blocklist associated with this policy. The blocklist is a collection hashes, paths, or signers which extends the list of processes the endpoint considers malicious. See the blocklist tab for entry details."
    }))
  }))), isPlatinumPlus && /*#__PURE__*/_react.default.createElement(_user_notification.UserNotification, {
    protection: protection,
    osList: OSes
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.detectionRulesMessage",
    defaultMessage: "View {detectionRulesLink}. Prebuilt rules are tagged \u201CElastic\u201D on the Detection Rules page.",
    values: {
      detectionRulesLink: /*#__PURE__*/_react.default.createElement(_link_to_app.LinkToApp, {
        appId: _constants.APP_UI_ID,
        deepLinkId: _types.SecurityPageName.rules
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.details.detectionRulesLink",
        defaultMessage: "related detection rules"
      }))
    }
  })));
});
exports.MalwareProtections = MalwareProtections;
MalwareProtections.displayName = 'MalwareProtections';