"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LockedPolicyCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LockedPolicyDiv = _styledComponents.default.div`
  .euiCard__betaBadgeWrapper {
    .euiCard__betaBadge {
      width: auto;
    }
  }
  .lockedCardDescription {
    padding: 0 33.3%;
  }
`;
const LockedPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  title
}) => {
  return /*#__PURE__*/_react.default.createElement(LockedPolicyDiv, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": "lockedPolicyCard",
    betaBadgeProps: {
      label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.platinum', {
        defaultMessage: 'Platinum'
      })
    },
    isDisabled: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "lock"
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement("strong", null, title)),
    description: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "lockedCardDescription",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.upgradeToPlatinum",
    defaultMessage: "Upgrade to Elastic Platinum"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.lockedCardUpgradeMessage",
    defaultMessage: "To turn on this protection, you must upgrade your license to Platinum, start a free 30-day trial, or spin up a {cloudDeploymentLink} on AWS, GCP, or Azure.",
    values: {
      cloudDeploymentLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/cloud/",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.details.cloudDeploymentLInk",
        defaultMessage: "cloud deployment"
      }))
    }
  })))))));
});
exports.LockedPolicyCard = LockedPolicyCard;
LockedPolicyCard.displayName = 'LockedPolicyCard';