"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SupportedVersionNotice = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _popup_options_to_versions = require("../protections/popup_options_to_versions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SupportedVersionNotice = ({
  optionName
}) => {
  const version = _popup_options_to_versions.popupVersionsMap.get(optionName);
  if (!version) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "policySupportedVersions"
  }, /*#__PURE__*/_react.default.createElement("i", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.supportedVersion",
    defaultMessage: "Agent version {version}",
    values: {
      version
    }
  })));
};
exports.SupportedVersionNotice = SupportedVersionNotice;