"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RadioButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _types = require("../../../../../../../common/endpoint/types");
var _config_form = require("../../components/config_form");
var _protection_radio = require("./protection_radio");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RadioButtons = /*#__PURE__*/_react.default.memo(({
  protection,
  osList
}) => {
  const radios = (0, _react.useMemo)(() => {
    return [{
      id: _types.ProtectionModes.detect,
      label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.detect', {
        defaultMessage: 'Detect'
      })
    }, {
      id: _types.ProtectionModes.prevent,
      label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.prevent', {
        defaultMessage: 'Prevent'
      })
    }];
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_config_form.ConfigFormHeading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetailsConfig.protectionLevel",
    defaultMessage: "Protection level"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_protection_radio.ProtectionRadio, {
    protection: protection,
    protectionMode: radios[0].id,
    osList: osList,
    key: {
      protection
    } + radios[0].id,
    label: radios[0].label
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 5
  }, /*#__PURE__*/_react.default.createElement(_protection_radio.ProtectionRadio, {
    protection: protection,
    protectionMode: radios[1].id,
    osList: osList,
    key: {
      protection
    } + radios[1].id,
    label: radios[1].label
  }))));
});
exports.RadioButtons = RadioButtons;
RadioButtons.displayName = 'RadioButtons';