"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _use_license = require("../../../../../../common/hooks/use_license");
var _selectors = require("../../../store/policy_details/selectors");
var _policy_hooks = require("../../policy_hooks");
var _types = require("../../../../../../../common/endpoint/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProtectionSwitch = /*#__PURE__*/_react.default.memo(({
  protection,
  protectionLabel,
  osList,
  additionalOnSwitchChange
}) => {
  const policyDetailsConfig = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyConfig);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const selected = policyDetailsConfig && policyDetailsConfig.windows[protection].mode;
  const handleSwitchChange = (0, _react.useCallback)(event => {
    if (policyDetailsConfig) {
      const newPayload = (0, _lodash.cloneDeep)(policyDetailsConfig);
      if (event.target.checked === false) {
        for (const os of osList) {
          if (os === 'windows') {
            newPayload[os][protection].mode = _types.ProtectionModes.off;
          } else if (os === 'mac') {
            newPayload[os][protection].mode = _types.ProtectionModes.off;
          } else if (os === 'linux') {
            newPayload[os][protection].mode = _types.ProtectionModes.off;
          }
          if (isPlatinumPlus) {
            if (os === 'windows') {
              newPayload[os].popup[protection].enabled = event.target.checked;
            } else if (os === 'mac') {
              newPayload[os].popup[protection].enabled = event.target.checked;
            } else if (os === 'linux') {
              newPayload[os].popup[protection].enabled = event.target.checked;
            }
          }
        }
      } else {
        for (const os of osList) {
          if (os === 'windows') {
            newPayload[os][protection].mode = _types.ProtectionModes.prevent;
          } else if (os === 'mac') {
            newPayload[os][protection].mode = _types.ProtectionModes.prevent;
          } else if (os === 'linux') {
            newPayload[os][protection].mode = _types.ProtectionModes.prevent;
          }
          if (isPlatinumPlus) {
            if (os === 'windows') {
              newPayload[os].popup[protection].enabled = event.target.checked;
            } else if (os === 'mac') {
              newPayload[os].popup[protection].enabled = event.target.checked;
            } else if (os === 'linux') {
              newPayload[os].popup[protection].enabled = event.target.checked;
            }
          }
        }
      }
      if (additionalOnSwitchChange) {
        dispatch({
          type: 'userChangedPolicyConfig',
          payload: {
            policyConfig: additionalOnSwitchChange({
              value: event.target.checked,
              policyConfigData: newPayload,
              protectionOsList: osList
            })
          }
        });
      } else {
        dispatch({
          type: 'userChangedPolicyConfig',
          payload: {
            policyConfig: newPayload
          }
        });
      }
    }
  }, [dispatch, policyDetailsConfig, isPlatinumPlus, protection, osList, additionalOnSwitchChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.protectionsEnabled', {
      defaultMessage: '{protectionLabel} {mode, select, true {enabled} false {disabled}}',
      values: {
        protectionLabel,
        mode: selected !== _types.ProtectionModes.off
      }
    }),
    checked: selected !== _types.ProtectionModes.off,
    onChange: handleSwitchChange,
    disabled: !showEditableFormFields,
    "data-test-subj": `${protection}ProtectionSwitch`
  });
});
exports.ProtectionSwitch = ProtectionSwitch;
ProtectionSwitch.displayName = 'ProtectionSwitch';