"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionRadio = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _types = require("../../../../../../../common/endpoint/types");
var _policy_hooks = require("../../policy_hooks");
var _selectors = require("../../../store/policy_details/selectors");
var _use_license = require("../../../../../../common/hooks/use_license");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProtectionRadio = /*#__PURE__*/_react.default.memo(({
  protection,
  protectionMode,
  osList,
  label
}) => {
  const policyDetailsConfig = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyConfig);
  const dispatch = (0, _reactRedux.useDispatch)();
  const radioButtonId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const selected = policyDetailsConfig && policyDetailsConfig.windows[protection].mode;
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();
  const handleRadioChange = (0, _react.useCallback)(() => {
    if (policyDetailsConfig) {
      const newPayload = (0, _lodash.cloneDeep)(policyDetailsConfig);
      for (const os of osList) {
        if (os === 'windows') {
          newPayload[os][protection].mode = protectionMode;
        } else if (os === 'mac') {
          newPayload[os][protection].mode = protectionMode;
        } else if (os === 'linux') {
          newPayload[os][protection].mode = protectionMode;
        }
        if (isPlatinumPlus) {
          if (os === 'windows') {
            if (protectionMode === _types.ProtectionModes.prevent) {
              newPayload[os].popup[protection].enabled = true;
            } else {
              newPayload[os].popup[protection].enabled = false;
            }
          } else if (os === 'mac') {
            if (protectionMode === _types.ProtectionModes.prevent) {
              newPayload[os].popup[protection].enabled = true;
            } else {
              newPayload[os].popup[protection].enabled = false;
            }
          } else if (os === 'linux') {
            if (protectionMode === _types.ProtectionModes.prevent) {
              newPayload[os].popup[protection].enabled = true;
            } else {
              newPayload[os].popup[protection].enabled = false;
            }
          }
        }
      }
      dispatch({
        type: 'userChangedPolicyConfig',
        payload: {
          policyConfig: newPayload
        }
      });
    }
  }, [dispatch, protectionMode, policyDetailsConfig, isPlatinumPlus, osList, protection]);

  /**
   *  Passing an arbitrary id because EuiRadio
   *  requires an id if label is passed
   */

  return /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    className: "policyDetailsProtectionRadio",
    label: label,
    id: radioButtonId,
    checked: selected === protectionMode,
    onChange: handleRadioChange,
    disabled: !showEditableFormFields || selected === _types.ProtectionModes.off,
    "data-test-subj": `${protection}ProtectionMode_${protectionMode}`
  });
});
exports.ProtectionRadio = ProtectionRadio;
ProtectionRadio.displayName = 'ProtectionRadio';