"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyFormLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_experimental_features = require("../../../../../../common/hooks/use_experimental_features");
var _policy_hooks = require("../../policy_hooks");
var _selectors = require("../../../store/policy_details/selectors");
var _kibana = require("../../../../../../common/lib/kibana");
var _routing = require("../../../../../common/routing");
var _use_navigate_to_app_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _constants = require("../../../../../../../common/constants");
var _page_wrapper = require("../../../../../../common/components/page_wrapper");
var _policy_details_form = require("../../policy_details_form");
var _policy_form_confirm_update = require("./policy_form_confirm_update");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyFormLayout = /*#__PURE__*/_react.default.memo(() => {
  var _policyItem$name, _policyAgentStatusSum;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    services: {
      theme,
      application: {
        navigateToApp
      }
    }
  } = (0, _kibana.useKibana)();
  const toasts = (0, _kibana.useToasts)();
  const {
    state: locationRouteState
  } = (0, _reactRouterDom.useLocation)();
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();

  // Store values
  const policyItem = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyDetails);
  const policyAgentStatusSummary = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.agentStatusSummary);
  const policyUpdateStatus = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.updateStatus);
  const isPolicyLoading = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isLoading);

  // Local state
  const [showConfirm, setShowConfirm] = (0, _react.useState)(false);
  const [routeState, setRouteState] = (0, _react.useState)();
  const policyName = (_policyItem$name = policyItem === null || policyItem === void 0 ? void 0 : policyItem.name) !== null && _policyItem$name !== void 0 ? _policyItem$name : '';
  const isPolicyListEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('policyListEnabled');
  const routingOnCancelNavigateTo = routeState === null || routeState === void 0 ? void 0 : routeState.onCancelNavigateTo;
  const navigateToAppArguments = (0, _react.useMemo)(() => {
    if (routingOnCancelNavigateTo) {
      return routingOnCancelNavigateTo;
    }
    return [_constants.APP_UI_ID, {
      path: isPolicyListEnabled ? (0, _routing.getPoliciesPath)() : (0, _routing.getEndpointListPath)({
        name: 'endpointList'
      })
    }];
  }, [isPolicyListEnabled, routingOnCancelNavigateTo]);

  // Handle showing update statuses
  (0, _react.useEffect)(() => {
    if (policyUpdateStatus) {
      if (policyUpdateStatus.success) {
        toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateSuccessTitle', {
            defaultMessage: 'Success!'
          }),
          text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement("span", {
            "data-test-subj": "policyDetailsSuccessMessage"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.endpoint.policy.details.updateSuccessMessage",
            defaultMessage: "Integration {name} has been updated.",
            values: {
              name: policyName
            }
          })), {
            theme$: theme.theme$
          })
        });
        if (routeState && routeState.onSaveNavigateTo) {
          navigateToApp(...routeState.onSaveNavigateTo);
        }
      } else {
        toasts.addDanger({
          title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateErrorTitle', {
            defaultMessage: 'Failed!'
          }),
          // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
          text: policyUpdateStatus.error.message
        });
      }
    }
  }, [navigateToApp, toasts, policyName, policyUpdateStatus, routeState, theme.theme$]);
  const handleCancelOnClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(...navigateToAppArguments);
  const handleSaveOnClick = (0, _react.useCallback)(() => {
    setShowConfirm(true);
  }, []);
  const handleSaveConfirmation = (0, _react.useCallback)(() => {
    dispatch({
      type: 'userClickedPolicyDetailsSaveButton'
    });
    setShowConfirm(false);
  }, [dispatch]);
  const handleSaveCancel = (0, _react.useCallback)(() => {
    setShowConfirm(false);
  }, []);
  (0, _react.useEffect)(() => {
    if (!routeState && locationRouteState) {
      setRouteState(locationRouteState);
    }
  }, [locationRouteState, routeState]);

  // Before proceeding - check if we have a policy data.
  // If not, and we are still loading, show spinner.
  // Else, if we have an error, then show error on the page.
  if (!policyItem) {
    return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
      noTimeline: true
    }, isPolicyLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    }) : null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConfirm && /*#__PURE__*/_react.default.createElement(_policy_form_confirm_update.ConfirmUpdate, {
    endpointCount: (_policyAgentStatusSum = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.total) !== null && _policyAgentStatusSum !== void 0 ? _policyAgentStatusSum : 0,
    onCancel: handleSaveCancel,
    onConfirm: handleSaveConfirmation
  }), /*#__PURE__*/_react.default.createElement(_policy_details_form.PolicyDetailsForm, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    onClick: handleCancelOnClick,
    "data-test-subj": "policyDetailsCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.cancel",
    defaultMessage: "Cancel"
  })))), showEditableFormFields && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "save",
    "data-test-subj": "policyDetailsSaveButton",
    onClick: handleSaveOnClick,
    isLoading: isPolicyLoading
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.save",
    defaultMessage: "Save"
  }))))));
});
exports.PolicyFormLayout = PolicyFormLayout;
PolicyFormLayout.displayName = 'PolicyFormLayout';