"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _policy_hooks = require("./policy_hooks");
var _selectors = require("../store/policy_details/selectors");
var _agents_summary = require("./agents_summary");
var _tabs = require("./tabs");
var _administration_list_page = require("../../../components/administration_list_page");
var _back_to_external_app_button = require("../../../components/back_to_external_app_button/back_to_external_app_button");
var _routing = require("../../../common/routing");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyDetails = /*#__PURE__*/_react.default.memo(() => {
  var _policyItem$name, _policyItem$descripti, _policyAgentStatusSum, _policyAgentStatusSum2, _policyAgentStatusSum3, _policyAgentStatusSum4;
  const isPolicyListEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('policyListEnabled');
  const {
    state: routeState = {}
  } = (0, _reactRouterDom.useLocation)();
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();

  // Store values
  const policyApiError = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.apiError);
  const policyItem = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.policyDetails);
  const policyAgentStatusSummary = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.agentStatusSummary);

  // Local state
  const policyName = (_policyItem$name = policyItem === null || policyItem === void 0 ? void 0 : policyItem.name) !== null && _policyItem$name !== void 0 ? _policyItem$name : '';
  const policyDescription = (_policyItem$descripti = policyItem === null || policyItem === void 0 ? void 0 : policyItem.description) !== null && _policyItem$descripti !== void 0 ? _policyItem$descripti : undefined;
  const backLinkOptions = (0, _react.useMemo)(() => {
    if (routeState !== null && routeState !== void 0 && routeState.backLink) {
      return {
        onBackButtonNavigateTo: routeState.backLink.navigateTo,
        backButtonLabel: routeState.backLink.label,
        backButtonUrl: routeState.backLink.href
      };
    }
    if (isPolicyListEnabled) {
      // default is to go back to the policy list
      const policyListPath = (0, _routing.getPoliciesPath)();
      return {
        backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.policyDetails.backToPolicyButton', {
          defaultMessage: 'Back to policy list'
        }),
        backButtonUrl: getAppUrl({
          path: policyListPath
        }),
        onBackButtonNavigateTo: [_constants.APP_UI_ID, {
          path: policyListPath
        }]
      };
    } else {
      // remove else block once policy list is not hidden behind feature flag
      const endpointListPath = (0, _routing.getEndpointListPath)({
        name: 'endpointList'
      });
      return {
        backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.policyDetails.backToEndpointList', {
          defaultMessage: 'View all endpoints'
        }),
        backButtonUrl: getAppUrl({
          path: endpointListPath
        }),
        onBackButtonNavigateTo: [_constants.APP_UI_ID, {
          path: endpointListPath
        }]
      };
    }
  }, [getAppUrl, routeState === null || routeState === void 0 ? void 0 : routeState.backLink, isPolicyListEnabled]);
  const headerRightContent = /*#__PURE__*/_react.default.createElement(_agents_summary.AgentsSummary, {
    total: (_policyAgentStatusSum = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.total) !== null && _policyAgentStatusSum !== void 0 ? _policyAgentStatusSum : 0,
    online: (_policyAgentStatusSum2 = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.online) !== null && _policyAgentStatusSum2 !== void 0 ? _policyAgentStatusSum2 : 0,
    offline: (_policyAgentStatusSum3 = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.offline) !== null && _policyAgentStatusSum3 !== void 0 ? _policyAgentStatusSum3 : 0,
    error: (_policyAgentStatusSum4 = policyAgentStatusSummary === null || policyAgentStatusSummary === void 0 ? void 0 : policyAgentStatusSummary.error) !== null && _policyAgentStatusSum4 !== void 0 ? _policyAgentStatusSum4 : 0
  });
  const backToEndpointList = /*#__PURE__*/_react.default.createElement(_back_to_external_app_button.BackToExternalAppButton, (0, _extends2.default)({}, backLinkOptions, {
    "data-test-subj": "policyDetailsBackLink"
  }));
  const pageBody = (0, _react.useMemo)(() => {
    if (policyApiError) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate_Deprecated, {
        template: "centeredContent"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: "danger",
        title: policyApiError === null || policyApiError === void 0 ? void 0 : policyApiError.error
      }, /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "policyDetailsIdNotFoundMessage"
      }, policyApiError === null || policyApiError === void 0 ? void 0 : policyApiError.message)));
    }
    if (!policyItem) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate_Deprecated, {
        template: "centeredContent"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        className: "essentialAnimation",
        size: "xl",
        "data-test-subj": "policyDetailsLoading"
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_tabs.PolicyTabs, null);
  }, [policyApiError, policyItem]);
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    "data-test-subj": "policyDetailsPage",
    title: policyName,
    subtitle: policyDescription,
    headerBackComponent: backToEndpointList,
    actions: policyApiError ? undefined : headerRightContent,
    restrictWidth: true,
    hasBottomBorder: false
  }, pageBody);
});
exports.PolicyDetails = PolicyDetails;
PolicyDetails.displayName = 'PolicyDetails';