"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyArtifactCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../../../../common/components/user_privileges");
var _translations = require("../translations");
var _use_can_access_some_artifacts = require("../../hooks/use_can_access_some_artifacts");
var _services = require("../../../../../blocklist/services");
var _host_isolation_exceptions_api_client = require("../../../../../host_isolation_exceptions/host_isolation_exceptions_api_client");
var _api_client = require("../../../../../event_filters/service/api_client");
var _service = require("../../../../../trusted_apps/service");
var _routing = require("../../../../../../common/routing");
var _constants = require("../../../../../trusted_apps/constants");
var _fleet_integration_artifacts_card = require("./fleet_integration_artifacts_card");
var _constants2 = require("../../../../../event_filters/constants");
var _constants3 = require("../../../../../host_isolation_exceptions/constants");
var _constants4 = require("../../../../../blocklist/constants");
var _kibana = require("../../../../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TrustedAppsPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const trustedAppsApiClientInstance = (0, _react.useMemo)(() => _service.TrustedAppsApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyTrustedAppsPath)(policyId);
    }
    return (0, _routing.getTrustedAppsListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: trustedAppsApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants.SEARCHABLE_FIELDS,
    labels: _translations.TRUSTED_APPS_LABELS,
    "data-test-subj": "trustedApps"
  });
});
TrustedAppsPolicyCard.displayName = 'TrustedAppsPolicyCard';
const EventFiltersPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const eventFiltersApiClientInstance = (0, _react.useMemo)(() => _api_client.EventFiltersApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyEventFiltersPath)(policyId);
    }
    return (0, _routing.getEventFiltersListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: eventFiltersApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants2.SEARCHABLE_FIELDS,
    labels: _translations.EVENT_FILTERS_LABELS,
    "data-test-subj": "eventFilters"
  });
});
EventFiltersPolicyCard.displayName = 'EventFiltersPolicyCard';
const HostIsolationExceptionsPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const hostIsolationExceptionsApiClientInstance = (0, _react.useMemo)(() => _host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyHostIsolationExceptionsPath)(policyId);
    }
    return (0, _routing.getHostIsolationExceptionsListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: hostIsolationExceptionsApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants3.SEARCHABLE_FIELDS,
    labels: _translations.HOST_ISOLATION_EXCEPTIONS_LABELS,
    "data-test-subj": "hostIsolationExceptions"
  });
});
HostIsolationExceptionsPolicyCard.displayName = 'HostIsolationExceptionsPolicyCard';
const BlocklistPolicyCard = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const http = (0, _kibana.useHttp)();
  const blocklistsApiClientInstance = (0, _react.useMemo)(() => _services.BlocklistsApiClient.getInstance(http), [http]);
  const {
    canReadPolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const getArtifactPathHandler = (0, _react.useCallback)(() => {
    if (canReadPolicyManagement) {
      return (0, _routing.getPolicyBlocklistsPath)(policyId);
    }
    return (0, _routing.getBlocklistsListPath)({
      includedPolicies: `${policyId},global`
    });
  }, [canReadPolicyManagement, policyId]);
  return /*#__PURE__*/_react.default.createElement(_fleet_integration_artifacts_card.FleetIntegrationArtifactsCard, {
    policyId: policyId,
    artifactApiClientInstance: blocklistsApiClientInstance,
    getArtifactsPath: getArtifactPathHandler,
    searchableFields: _constants4.SEARCHABLE_FIELDS,
    labels: _translations.BLOCKLISTS_LABELS,
    "data-test-subj": "blocklists"
  });
});
BlocklistPolicyCard.displayName = 'BlocklistPolicyCard';
/**
 * Displays the Artifact cards on the Edit Integration Policy form within Fleet according to the
 * current user's authz
 */
const EndpointPolicyArtifactCards = /*#__PURE__*/(0, _react.memo)(({
  policyId
}) => {
  const {
    loading,
    canReadBlocklist,
    canReadEventFilters,
    canReadTrustedApplications,
    canReadHostIsolationExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const canAccessArtifactContent = (0, _use_can_access_some_artifacts.useCanAccessSomeArtifacts)();
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
      lines: 4
    });
  }
  if (!canAccessArtifactContent) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetails.artifacts.title",
    defaultMessage: "Artifacts"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), canReadTrustedApplications && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TrustedAppsPolicyCard, {
    policyId: policyId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), canReadEventFilters && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EventFiltersPolicyCard, {
    policyId: policyId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), canReadHostIsolationExceptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(HostIsolationExceptionsPolicyCard, {
    policyId: policyId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), canReadBlocklist && /*#__PURE__*/_react.default.createElement(BlocklistPolicyCard, {
    policyId: policyId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }));
});
exports.EndpointPolicyArtifactCards = EndpointPolicyArtifactCards;
EndpointPolicyArtifactCards.displayName = 'EndpointPolicyArtifactCards';