"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyCreateMultiStepExtension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _css = require("@emotion/css");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CenteredEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  align-items: center;
`;

/**
 * A component to be displayed in multi step onboarding process.
 */
const EndpointPolicyCreateMultiStepExtension = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const {
    size
  } = (0, _eui.useEuiTheme)().euiTheme;
  const title = /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.multiStepOnboarding.title",
    defaultMessage: "We'll save your integration with our recommended defaults."
  })));
  const logoSize = `calc(2 * ${size.xxxxl})`;
  const securityLogo = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    css: (0, _css.css)`
        width: ${logoSize};
        height: ${logoSize};
      `
  });
  const features = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.multiStepOnboarding.feature",
    defaultMessage: "Windows, macOS, and Linux event collection"
  })))));
  const details = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.multiStepOnboarding.details",
    defaultMessage: "You can edit these settings later in the Elastic Defend integration policy."
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.securitySolution.configureEndpointIntegrationPolicy,
    target: "_blank",
    external: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.multiStepOnboarding.learnMore",
    defaultMessage: "Learn more"
  }))));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), title, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _css.css)`
          padding: ${size.xxxl} 0;
        `
  }, /*#__PURE__*/_react.default.createElement(CenteredEuiFlexItem, {
    grow: false
  }, securityLogo), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, features))), details, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }));
});
exports.EndpointPolicyCreateMultiStepExtension = EndpointPolicyCreateMultiStepExtension;
EndpointPolicyCreateMultiStepExtension.displayName = 'EndpointPolicyCreateMultiStepExtension';