"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPolicyCreateExtension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_license = require("../../../../../../common/hooks/use_license");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREFIX = 'endpoint_policy_create_extension';
const ENDPOINT_INTEGRATION_CONFIG_KEY = 'ENDPOINT_INTEGRATION_CONFIG';
const environmentMapping = {
  cloud: _translations.CLOUD_SECURITY,
  endpoint: _translations.ENDPOINT
};
const endpointPresetsMapping = {
  NGAV: {
    label: _translations.NGAV,
    note: _translations.NGAV_NOTE
  },
  EDREssential: {
    label: _translations.EDR_ESSENTIAL,
    note: _translations.EDR_NOTE
  },
  EDRComplete: {
    label: _translations.EDR_COMPLETE,
    note: _translations.EDR_NOTE
  },
  DataCollection: {
    label: _translations.DATA_COLLECTION,
    note: null
  }
};
const cloudEventMapping = {
  INTERACTIVE_ONLY: _translations.INTERACTIVE_ONLY,
  ALL_EVENTS: _translations.ALL_EVENTS
};
const environmentOptions = [{
  value: 'endpoint',
  text: _translations.ENDPOINT
}, {
  value: 'cloud',
  text: _translations.CLOUD_SECURITY
}];
const HelpTextWithPadding = _styledComponents.default.div`
  padding-left: ${props => props.theme.eui.euiSizeL};
`;

/**
 * Exports Endpoint-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const EndpointPolicyCreateExtension = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange
}) => {
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();
  const [endpointPreset, setEndpointPreset] = (0, _react.useState)('EDRComplete');
  const [selectedCloudEvent, setSelectedCloudEvent] = (0, _react.useState)('INTERACTIVE_ONLY');
  const [selectedEnvironment, setSelectedEnvironment] = (0, _react.useState)('endpoint');

  // Show NGAV license note when Gold and below
  // Show EDR licenses note when Platinum and Below
  const showNote = endpointPreset === 'NGAV' && !isPlatinumPlus || ['EDREssential', 'EDRComplete'].includes(endpointPreset) && !isEnterprise;

  // Fleet will initialize the create form with a default name for the integrating policy, however,
  // for endpoint security, we want the user to explicitly type in a name, so we blank it out
  // only during 1st component render (thus why the eslint disabled rule below).
  // Default values for config are endpoint + NGAV
  (0, _react.useEffect)(() => {
    if (newPolicy.inputs.length === 0) {
      onChange({
        isValid: false,
        updatedPolicy: {
          ...newPolicy,
          name: '',
          inputs: [{
            enabled: true,
            streams: [],
            type: ENDPOINT_INTEGRATION_CONFIG_KEY,
            config: {
              _config: {
                value: {
                  type: 'endpoint',
                  endpointConfig: {
                    preset: 'NGAV'
                  }
                }
              }
            }
          }]
        }
      });
    } else {
      onChange({
        isValid: true,
        updatedPolicy: {
          ...newPolicy,
          inputs: [{
            ...newPolicy.inputs[0],
            config: {
              _config: {
                value: {
                  type: selectedEnvironment,
                  ...(selectedEnvironment === 'cloud' ? {
                    eventFilters: {
                      nonInteractiveSession: selectedCloudEvent === 'INTERACTIVE_ONLY'
                    }
                  } : {
                    endpointConfig: {
                      preset: endpointPreset
                    }
                  })
                }
              }
            }
          }]
        }
      });
    }
  }, [selectedEnvironment, selectedCloudEvent, endpointPreset, onChange, newPolicy]);
  const onChangeEnvironment = (0, _react.useCallback)(e => {
    var _e$target;
    setSelectedEnvironment(e === null || e === void 0 ? void 0 : (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.value);
  }, []);
  const onChangeCloudEvent = (0, _react.useCallback)(e => {
    setSelectedCloudEvent(e.target.value);
  }, []);
  const onChangeEndpointPreset = (0, _react.useCallback)(e => {
    setEndpointPreset(e.target.value);
  }, []);
  const getEndpointPresetsProps = (0, _react.useCallback)(preset => ({
    id: `${PREFIX}_endpoint_preset_${preset}`,
    label: endpointPresetsMapping[preset].label,
    value: preset,
    checked: endpointPreset === preset,
    onChange: onChangeEndpointPreset
  }), [endpointPreset, onChangeEndpointPreset]);
  const getCloudEventsProps = (0, _react.useCallback)(cloudEvent => ({
    id: `${PREFIX}_cloud_event_${cloudEvent}`,
    label: cloudEventMapping[cloudEvent],
    value: cloudEvent,
    checked: selectedCloudEvent === cloudEvent,
    onChange: onChangeCloudEvent
  }), [selectedCloudEvent, onChangeCloudEvent]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.enablePrevention",
    defaultMessage: "Select configuration settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.quickSettingsTranslation",
    defaultMessage: "Use quick settings to configure the integration to {environments}. You can make configuration changes after you create the integration.",
    values: {
      environments: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.ingestManager.createPackagePolicy.environments",
        defaultMessage: "protect your traditional endpoints or dynamic cloud environments"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.selectEnvironmentTextTranslation",
      defaultMessage: "Select the type of environment you want to protect:"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    id: "selectIntegrationTypeId",
    "data-test-subj": "selectIntegrationTypeId",
    options: environmentOptions,
    value: selectedEnvironment,
    onChange: onChangeEnvironment,
    fullWidth: true
  })), selectedEnvironment === 'endpoint' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(HelpTextWithPadding, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointDataCollection",
      defaultMessage: "Augment your existing anti-virus solution with advanced data collection and detection"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, getEndpointPresetsProps('DataCollection'))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(HelpTextWithPadding, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointNGAV",
      defaultMessage: "Machine learning malware, ransomware, memory threat, malicious behavior, and credential theft preventions, plus process telemetry"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, getEndpointPresetsProps('NGAV'))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(HelpTextWithPadding, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointEDREssential",
      defaultMessage: "Everything in NGAV, plus file and network telemetry"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, getEndpointPresetsProps('EDREssential'))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(HelpTextWithPadding, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointEDRComplete",
      defaultMessage: "Everything in Essential EDR, plus full telemetry"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, getEndpointPresetsProps('EDRComplete'))), showNote && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "create-ensdpoint-policy-license-note"
  }, /*#__PURE__*/_react.default.createElement("p", null, endpointPresetsMapping[endpointPreset].note, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.seeDocumentation",
    defaultMessage: "See {documentation} for more information.",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/configure-endpoint-integration-policy.html",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.ingestManager.createPackagePolicy.seeDocumentationLink",
        defaultMessage: "documentation"
      }))
    }
  })))))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.createPackagePolicy.stepConfigure.interactiveSessionSuggestionTranslation",
    defaultMessage: "To reduce data ingestion volume, select Interactive only"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(HelpTextWithPadding, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeAllEventsInfo",
      defaultMessage: "Monitors and collects data from all system executions, including those launched by daemon processes, such as {nginx}, {postgres} and {cron}. {recommendation}",
      values: {
        nginx: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'nginx'),
        postgres: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'postgres'),
        cron: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'cron'),
        recommendation: /*#__PURE__*/_react.default.createElement("em", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeAllEventsInfoRecommendation",
          defaultMessage: "Recommended for Cloud Workload Protection, auditing and forensics use cases."
        })))
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, getCloudEventsProps('ALL_EVENTS'))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(HelpTextWithPadding, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeInteractiveOnlyInfo",
      defaultMessage: "Captures live system interactions initiated by users through programs like {ssh} or {telnet}. {recommendation}",
      values: {
        ssh: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ssh'),
        telnet: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'telnet'),
        recommendation: /*#__PURE__*/_react.default.createElement("em", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeInteractiveOnlyInfoRecommendation",
          defaultMessage: "Recommended for auditing and forensic use cases."
        })))
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, getCloudEventsProps('INTERACTIVE_ONLY')))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }));
}, (prevProps, nextProps) => {
  return prevProps.newPolicy.name === nextProps.newPolicy.name;
});
exports.EndpointPolicyCreateExtension = EndpointPolicyCreateExtension;
EndpointPolicyCreateExtension.displayName = 'EndpointPolicyCreateExtension';