"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRUSTED_APPS_LABELS = exports.HOST_ISOLATION_EXCEPTIONS_LABELS = exports.EVENT_FILTERS_LABELS = exports.BLOCKLISTS_LABELS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRUSTED_APPS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.trustedAppsSummary.error', {
    defaultMessage: 'There was an error trying to fetch trusted applications stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.trustedApps.fleetIntegration.title",
    defaultMessage: "Trusted applications"
  })
};
exports.TRUSTED_APPS_LABELS = TRUSTED_APPS_LABELS;
const EVENT_FILTERS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.eventFiltersSummary.error', {
    defaultMessage: 'There was an error trying to fetch event filters stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.eventFilters.fleetIntegration.title",
    defaultMessage: "Event filters"
  })
};
exports.EVENT_FILTERS_LABELS = EVENT_FILTERS_LABELS;
const HOST_ISOLATION_EXCEPTIONS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.hostIsolationExceptionsSummary.error', {
    defaultMessage: 'There was an error trying to fetch host isolation exceptions stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolationExceptions.fleetIntegration.title",
    defaultMessage: "Host isolation exceptions"
  })
};
exports.HOST_ISOLATION_EXCEPTIONS_LABELS = HOST_ISOLATION_EXCEPTIONS_LABELS;
const BLOCKLISTS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.blocklistsSummary.error', {
    defaultMessage: 'There was an error trying to fetch blocklist stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.blocklists.fleetIntegration.title",
    defaultMessage: "Blocklist"
  })
};
exports.BLOCKLISTS_LABELS = BLOCKLISTS_LABELS;