"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointPackageCustomExtension = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../../../common/components/user_privileges");
var _no_privileges = require("../../../../../../common/components/no_privileges");
var _use_can_access_some_artifacts = require("../hooks/use_can_access_some_artifacts");
var _kibana = require("../../../../../../common/lib/kibana");
var _api_client = require("../../../../trusted_apps/service/api_client");
var _api_client2 = require("../../../../event_filters/service/api_client");
var _host_isolation_exceptions_api_client = require("../../../../host_isolation_exceptions/host_isolation_exceptions_api_client");
var _services = require("../../../../blocklist/services");
var _fleet_artifacts_card = require("./components/fleet_artifacts_card");
var _routing = require("../../../../../common/routing");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TrustedAppsArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const trustedAppsApiClientInstance = (0, _react.useMemo)(() => _api_client.TrustedAppsApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: trustedAppsApiClientInstance,
    getArtifactsPath: _routing.getTrustedAppsListPath,
    labels: _translations.TRUSTED_APPS_LABELS,
    "data-test-subj": "trustedApps"
  }));
});
TrustedAppsArtifactCard.displayName = 'TrustedAppsArtifactCard';
const EventFiltersArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const eventFiltersApiClientInstance = (0, _react.useMemo)(() => _api_client2.EventFiltersApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: eventFiltersApiClientInstance,
    getArtifactsPath: _routing.getEventFiltersListPath,
    labels: _translations.EVENT_FILTERS_LABELS,
    "data-test-subj": "eventFilters"
  }));
});
EventFiltersArtifactCard.displayName = 'EventFiltersArtifactCard';
const HostIsolationExceptionsArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const hostIsolationExceptionsApiClientInstance = (0, _react.useMemo)(() => _host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: hostIsolationExceptionsApiClientInstance,
    getArtifactsPath: _routing.getHostIsolationExceptionsListPath,
    labels: _translations.HOST_ISOLATION_EXCEPTIONS_LABELS,
    "data-test-subj": "hostIsolationExceptions"
  }));
});
HostIsolationExceptionsArtifactCard.displayName = 'HostIsolationExceptionsArtifactCard';
const BlockListArtifactCard = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const blocklistsApiClientInstance = (0, _react.useMemo)(() => _services.BlocklistsApiClient.getInstance(http), [http]);
  return /*#__PURE__*/_react.default.createElement(_fleet_artifacts_card.FleetArtifactsCard, (0, _extends2.default)({}, props, {
    artifactApiClientInstance: blocklistsApiClientInstance,
    getArtifactsPath: _routing.getBlocklistsListPath,
    labels: _translations.BLOCKLISTS_LABELS,
    "data-test-subj": "blocklists"
  }));
});
BlockListArtifactCard.displayName = 'BlockListArtifactCard';

/**
 * The UI displayed in Fleet's Endpoint integration page, under the `Advanced` tab
 */
const EndpointPackageCustomExtension = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    loading,
    canReadBlocklist,
    canReadEventFilters,
    canReadTrustedApplications,
    canReadHostIsolationExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const userCanAccessContent = (0, _use_can_access_some_artifacts.useCanAccessSomeArtifacts)();
  const artifactCards = (0, _react.useMemo)(() => {
    if (loading) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    }
    if (!userCanAccessContent) {
      return /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
        docLinkSelector: links => links.securitySolution.privileges
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "fleetEndpointPackageCustomContent"
    }, canReadTrustedApplications && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TrustedAppsArtifactCard, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), canReadEventFilters && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EventFiltersArtifactCard, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), canReadHostIsolationExceptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(HostIsolationExceptionsArtifactCard, props), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), canReadBlocklist && /*#__PURE__*/_react.default.createElement(BlockListArtifactCard, props));
  }, [canReadBlocklist, canReadEventFilters, canReadTrustedApplications, canReadHostIsolationExceptions, loading, props, userCanAccessContent]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: 'spaceAround'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      "data-test-subj": "endpointExtensionLoadingSpinner"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xl"
    })));
  }
  return artifactCards;
});
exports.EndpointPackageCustomExtension = EndpointPackageCustomExtension;
EndpointPackageCustomExtension.displayName = 'EndpointPackageCustomExtension';