"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSecurityContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _store = require("./store");
var _render_context_providers = require("./render_context_providers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a new component that wraps the provided `WrappedComponent` in a bare minimum set of rendering context
 * needed to render Security Solution components that may be dependent on a Redux store and/or Security Solution
 * specific context based functionality
 *
 * @param coreStart
 * @param depsStart
 * @param WrappedComponent
 */
const withSecurityContext = ({
  coreStart,
  depsStart,
  WrappedComponent
}) => {
  let store; // created on first render

  return /*#__PURE__*/(0, _react.memo)(props => {
    if (!store) {
      store = (0, _store.createFleetContextReduxStore)({
        coreStart,
        depsStart
      });
    }
    return /*#__PURE__*/_react.default.createElement(_render_context_providers.RenderContextProviders, {
      store: store,
      depsStart: depsStart
    }, /*#__PURE__*/_react.default.createElement(WrappedComponent, props));
  });
};
exports.withSecurityContext = withSecurityContext;