"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderContextProviders = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _user_privileges_context = require("../../../../../../../common/components/user_privileges/user_privileges_context");
var _query_client_provider = require("../../../../../../../common/containers/query_client/query_client_provider");
var _security_solution_start_dependencies = require("../../../../../../../common/components/user_privileges/endpoint/security_solution_start_dependencies");
var _current_license = require("../../../../../../../common/components/current_license");
var _kibana = require("../../../../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RenderContextProviders = /*#__PURE__*/(0, _react.memo)(({
  store,
  depsStart,
  queryClient,
  children
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_query_client_provider.ReactQueryClientProvider, {
    queryClient: queryClient
  }, /*#__PURE__*/_react.default.createElement(_security_solution_start_dependencies.SecuritySolutionStartDependenciesContext.Provider, {
    value: depsStart
  }, /*#__PURE__*/_react.default.createElement(_user_privileges_context.UserPrivilegesProvider, {
    kibanaCapabilities: capabilities
  }, /*#__PURE__*/_react.default.createElement(_current_license.CurrentLicense, null, children)))));
});
exports.RenderContextProviders = RenderContextProviders;
RenderContextProviders.displayName = 'RenderContextProviders';