"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_KEYS = ['windows', 'macos', 'linux', 'total'];
const SUMMARY_LABELS = {
  windows: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.windows', {
    defaultMessage: 'Windows'
  }),
  linux: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.linux', {
    defaultMessage: 'Linux'
  }),
  macos: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.macos', {
    defaultMessage: 'Mac'
  }),
  total: _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.exceptionItemsSummary.total', {
    defaultMessage: 'Total'
  })
};
const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  font-size: ${({
  isSmall,
  theme
}) => isSmall ? theme.eui.euiFontSizeXS : 'inherit'};
  font-weight: ${({
  isSmall
}) => isSmall ? '1px' : 'inherit'};
`;
const CSS_BOLD = {
  fontWeight: 'bold'
};
const ExceptionItemsSummary = /*#__PURE__*/(0, _react.memo)(({
  stats,
  isSmall = false
}) => {
  const getItem = (0, _react.useCallback)(stat => {
    var _stats$stat;
    if (stat !== 'total' && isSmall) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: stat
    }, /*#__PURE__*/_react.default.createElement(SummaryStat, {
      value: (_stats$stat = stats === null || stats === void 0 ? void 0 : stats[stat]) !== null && _stats$stat !== void 0 ? _stats$stat : 0,
      color: stat === 'total' && !isSmall ? 'primary' : 'default',
      key: stat,
      isSmall: isSmall
    }, SUMMARY_LABELS[stat]));
  }, [stats, isSmall]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: isSmall ? 'flexStart' : 'spaceAround',
    gutterSize: isSmall ? 's' : 'l'
  }, SUMMARY_KEYS.map(stat => getItem(stat)));
});
exports.ExceptionItemsSummary = ExceptionItemsSummary;
ExceptionItemsSummary.displayName = 'ExceptionItemsSummary';
const SummaryStat = /*#__PURE__*/(0, _react.memo)(({
  children,
  value,
  color,
  isSmall = false,
  ...commonProps
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-displayInlineBlock",
    size: isSmall ? 'xs' : 's'
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    justifyContent: isSmall ? 'flexStart' : 'center',
    direction: isSmall ? 'rowReverse' : 'row',
    alignItems: "center",
    gutterSize: isSmall ? 'xs' : 'l',
    isSmall: isSmall
  }, !isSmall ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: color === 'primary' ? CSS_BOLD : undefined
  }, children) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color
  }, value))));
});
SummaryStat.displayName = 'SummaryState';