"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AntivirusRegistrationForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _selectors = require("../../../store/policy_details/selectors");
var _policy_hooks = require("../../policy_hooks");
var _config_form = require("../config_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSLATIONS = {
  title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.type', {
    defaultMessage: 'Register as antivirus'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.explanation', {
    defaultMessage: 'Toggle on to register Elastic as an official Antivirus solution for Windows OS. ' + 'This will also disable Windows Defender.'
  }),
  label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.toggle', {
    defaultMessage: 'Register as antivirus'
  })
};
const AntivirusRegistrationForm = /*#__PURE__*/(0, _react.memo)(() => {
  const antivirusRegistrationEnabled = (0, _policy_hooks.usePolicyDetailsSelector)(_selectors.isAntivirusRegistrationEnabled);
  const dispatch = (0, _reactRedux.useDispatch)();
  const showEditableFormFields = (0, _policy_hooks.useShowEditableFormFields)();
  const handleSwitchChange = (0, _react.useCallback)(event => dispatch({
    type: 'userChangedAntivirusRegistration',
    payload: {
      enabled: event.target.checked
    }
  }), [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_config_form.ConfigForm, {
    type: TRANSLATIONS.title,
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS],
    dataTestSubj: "antivirusRegistrationForm",
    osRestriction: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.av.windowsServerNotSupported', {
      defaultMessage: 'Windows Server operating systems unsupported because Antivirus registration requires Windows Security Center, which is not included in Windows Server operating systems.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, TRANSLATIONS.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: TRANSLATIONS.label,
    checked: antivirusRegistrationEnabled,
    onChange: handleSwitchChange,
    disabled: !showEditableFormFields
  }));
});
exports.AntivirusRegistrationForm = AntivirusRegistrationForm;
AntivirusRegistrationForm.displayName = 'AntivirusRegistrationForm';