"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsEmptyUnassigned = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _policy_hooks = require("../../policy_hooks");
var _use_policy_artifacts_empty_hooks = require("./use_policy_artifacts_empty_hooks");
var _user_privileges = require("../../../../../../common/components/user_privileges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyArtifactsEmptyUnassigned = /*#__PURE__*/(0, _react.memo)(({
  policyId,
  policyName,
  listId,
  labels,
  canWriteArtifact = false,
  getPolicyArtifactsPath,
  getArtifactPath
}) => {
  const {
    canCreateArtifactsByPolicy
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    onClickHandler,
    toRouteUrl
  } = (0, _use_policy_artifacts_empty_hooks.useGetLinkTo)(policyId, policyName, getPolicyArtifactsPath, getArtifactPath);
  const navigateCallback = (0, _policy_hooks.usePolicyDetailsArtifactsNavigateCallback)(listId);
  const onClickPrimaryButtonHandler = (0, _react.useCallback)(() => navigateCallback({
    show: 'list'
  }), [navigateCallback]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate_Deprecated, {
    template: "centeredContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "plusInCircle",
    "data-test-subj": "policy-artifacts-empty-unassigned",
    title: /*#__PURE__*/_react.default.createElement("h2", null, labels.emptyUnassignedTitle),
    body: canWriteArtifact ? labels.emptyUnassignedMessage(policyName) : labels.emptyUnassignedNoPrivilegesMessage(policyName),
    actions: [...(canCreateArtifactsByPolicy && canWriteArtifact ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onClickPrimaryButtonHandler,
      "data-test-subj": "unassigned-assign-artifacts-button"
    }, labels.emptyUnassignedPrimaryActionButtonTitle)] : []), canWriteArtifact ?
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      onClick: onClickHandler,
      href: toRouteUrl,
      "data-test-subj": "unassigned-manage-artifacts-button"
    }, labels.emptyUnassignedSecondaryActionButtonTitle) : null]
  }));
});
exports.PolicyArtifactsEmptyUnassigned = PolicyArtifactsEmptyUnassigned;
PolicyArtifactsEmptyUnassigned.displayName = 'PolicyArtifactsEmptyUnassigned';