"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsDeleteModal = void 0;
var _eui = require("@elastic/eui");
var _reactQuery = require("@tanstack/react-query");
var _react = _interopRequireWildcard(require("react"));
var _artifacts = require("../../../../../hooks/artifacts");
var _kibana = require("../../../../../../common/lib/kibana");
var _artifacts2 = require("../../../../../../../common/endpoint/service/artifacts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyArtifactsDeleteModal = /*#__PURE__*/_react.default.memo(({
  policyId,
  policyName,
  apiClient,
  exception,
  onClose,
  labels
}) => {
  const toasts = (0, _kibana.useToasts)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const {
    mutate: updateArtifact,
    isLoading: isUpdateArtifactLoading
  } = (0, _artifacts.useBulkUpdateArtifact)(apiClient, {
    onSuccess: () => {
      toasts.addSuccess({
        title: labels.deleteModalSuccessMessageTitle,
        text: labels.deleteModalSuccessMessageText(exception, policyName)
      });
      queryClient.invalidateQueries(['list', apiClient]);
      onClose();
    },
    onError: error => {
      toasts.addError(error, {
        title: labels.deleteModalErrorMessage
      });
    }
  });
  const handleModalConfirm = (0, _react.useCallback)(() => {
    const modifiedException = {
      ...exception,
      tags: exception.tags.filter(tag => tag !== `${_artifacts2.BY_POLICY_ARTIFACT_TAG_PREFIX}${policyId}`)
    };
    updateArtifact([modifiedException]);
  }, [exception, policyId, updateArtifact]);
  const handleOnClose = (0, _react.useCallback)(() => {
    if (!isUpdateArtifactLoading) {
      onClose();
    }
  }, [isUpdateArtifactLoading, onClose]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onCancel: handleOnClose,
    onConfirm: handleModalConfirm,
    title: labels.deleteModalTitle,
    cancelButtonText: labels.deleteModalCancelButtonTitle,
    confirmButtonText: labels.deleteModalSubmitButtonTitle,
    isLoading: isUpdateArtifactLoading,
    "data-test-subj": 'remove-from-policy-dialog'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, labels.deleteModalImpactInfo)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, labels.deleteModalConfirmInfo)));
});
exports.PolicyArtifactsDeleteModal = PolicyArtifactsDeleteModal;