"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = require("styled-components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Display a summary of stats (counts) associated with a group of agents (ex. those associated with a Policy)
 */
const AgentsSummary = /*#__PURE__*/(0, _react.memo)(props => {
  const stats = (0, _react.useMemo)(() => {
    return [{
      key: 'total',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.totalTitle', {
        defaultMessage: 'Total agents'
      }),
      health: ''
    }, {
      key: 'online',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.onlineTitle', {
        defaultMessage: 'Healthy'
      }),
      health: 'success'
    }, {
      key: 'error',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.errorTitle', {
        defaultMessage: 'Unhealthy'
      }),
      health: 'warning'
    }, {
      key: 'offline',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.offlineTitle', {
        defaultMessage: 'Offline'
      }),
      health: 'subdued'
    }];
  }, []);
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    responsive: false,
    "data-test-subj": "policyAgentsSummary"
  }, stats.map(({
    key,
    title,
    health
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: key,
      style: {
        marginRight: key === 'total' ? theme.eui.euiSizeXXL : undefined
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      style: {
        textAlign: 'right'
      },
      listItems: [{
        title,
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, health && /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: health === 'warning' ? theme.eui.euiColorWarning : health,
          className: "eui-alignMiddle"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
          value: props[key]
        }))
      }]
    }));
  }));
});
exports.AgentsSummary = AgentsSummary;
AgentsSummary.displayName = 'AgentsSummary';