"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateStatus = exports.policyIdFromParams = exports.policyDetailsForUpdate = exports.policyDetails = exports.policyConfig = exports.needsToRefresh = exports.licensedPolicy = exports.licenseState = exports.license = exports.isOnPolicyDetailsPage = exports.isLoading = exports.isCredentialHardeningEnabled = exports.isAntivirusRegistrationEnabled = exports.fullPolicy = exports.apiError = exports.agentStatusSummary = void 0;
var _reactRouterDom = require("react-router-dom");
var _reselect = require("reselect");
var _policy_config = require("../../../../../../../common/license/policy_config");
var _policy_config2 = require("../../../../../../../common/endpoint/models/policy_config");
var _constants = require("../../../../../common/constants");
var _policy = require("../../../../../../../common/endpoint/service/policy");
var _policy_common_selectors = require("./policy_common_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Returns the policy details */
const policyDetails = state => state.policyItem;
/** Returns current active license */
exports.policyDetails = policyDetails;
const licenseState = state => state.license;
exports.licenseState = licenseState;
const licensedPolicy = (0, _reselect.createSelector)(policyDetails, licenseState, (policyData, license) => {
  if (policyData) {
    const policyValue = (0, _policy_config.unsetPolicyFeaturesAccordingToLicenseLevel)(policyData.inputs[0].config.policy.value, license);
    const newPolicyData = {
      ...policyData,
      inputs: [{
        ...policyData.inputs[0],
        config: {
          ...policyData.inputs[0].config,
          policy: {
            ...policyData.inputs[0].config.policy,
            value: policyValue
          }
        }
      }]
    };
    return newPolicyData;
  }
  return policyData;
});

/**
 * Return only the policy structure accepted for update/create
 */
exports.licensedPolicy = licensedPolicy;
const policyDetailsForUpdate = (0, _reselect.createSelector)(licensedPolicy, policy => {
  if (policy) {
    return (0, _policy.getPolicyDataForUpdate)(policy);
  }
});

/**
 * Checks if data needs to be refreshed
 */
exports.policyDetailsForUpdate = policyDetailsForUpdate;
const needsToRefresh = state => {
  return !state.policyItem && !state.apiError;
};

/** Returns a boolean of whether the user is on some of the policy details page or not */
exports.needsToRefresh = needsToRefresh;
const isOnPolicyDetailsPage = state => (0, _policy_common_selectors.isOnPolicyFormView)(state) || (0, _policy_common_selectors.isOnPolicyTrustedAppsView)(state) || (0, _policy_common_selectors.isOnPolicyEventFiltersView)(state) || (0, _policy_common_selectors.isOnHostIsolationExceptionsView)(state) || (0, _policy_common_selectors.isOnBlocklistsView)(state);

/** Returns the license info fetched from the license service */
exports.isOnPolicyDetailsPage = isOnPolicyDetailsPage;
const license = state => {
  return state.license;
};

/** Returns the policyId from the url */
exports.license = license;
const policyIdFromParams = (0, _reselect.createSelector)(state => state.location, location => {
  var _matchPath$params$pol, _matchPath, _matchPath$params, _location$pathname;
  return (_matchPath$params$pol = (_matchPath = (0, _reactRouterDom.matchPath)((_location$pathname = location === null || location === void 0 ? void 0 : location.pathname) !== null && _location$pathname !== void 0 ? _location$pathname : '', {
    path: [_constants.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH, _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH],
    exact: true
  })) === null || _matchPath === void 0 ? void 0 : (_matchPath$params = _matchPath.params) === null || _matchPath$params === void 0 ? void 0 : _matchPath$params.policyId) !== null && _matchPath$params$pol !== void 0 ? _matchPath$params$pol : '';
});
exports.policyIdFromParams = policyIdFromParams;
const defaultFullPolicy = (0, _policy_config2.policyFactory)();

/**
 * Returns the full Endpoint Policy, which will include private settings not shown on the UI.
 * Note: this will return a default full policy if the `policyItem` is `undefined`
 */
const fullPolicy = (0, _reselect.createSelector)(licensedPolicy, policyData => {
  var _policyData$inputs$0$, _policyData$inputs$, _policyData$inputs$$c, _policyData$inputs$$c2;
  return (_policyData$inputs$0$ = policyData === null || policyData === void 0 ? void 0 : (_policyData$inputs$ = policyData.inputs[0]) === null || _policyData$inputs$ === void 0 ? void 0 : (_policyData$inputs$$c = _policyData$inputs$.config) === null || _policyData$inputs$$c === void 0 ? void 0 : (_policyData$inputs$$c2 = _policyData$inputs$$c.policy) === null || _policyData$inputs$$c2 === void 0 ? void 0 : _policyData$inputs$$c2.value) !== null && _policyData$inputs$0$ !== void 0 ? _policyData$inputs$0$ : defaultFullPolicy;
});
exports.fullPolicy = fullPolicy;
const fullWindowsPolicySettings = (0, _reselect.createSelector)(fullPolicy, policy => policy === null || policy === void 0 ? void 0 : policy.windows);
const fullMacPolicySettings = (0, _reselect.createSelector)(fullPolicy, policy => policy === null || policy === void 0 ? void 0 : policy.mac);
const fullLinuxPolicySettings = (0, _reselect.createSelector)(fullPolicy, policy => policy === null || policy === void 0 ? void 0 : policy.linux);

/** Returns the policy configuration */
const policyConfig = (0, _reselect.createSelector)(fullWindowsPolicySettings, fullMacPolicySettings, fullLinuxPolicySettings, (windows, mac, linux) => {
  return {
    windows: {
      advanced: windows.advanced,
      events: windows.events,
      malware: windows.malware,
      ransomware: windows.ransomware,
      memory_protection: windows.memory_protection,
      behavior_protection: windows.behavior_protection,
      popup: windows.popup,
      antivirus_registration: windows.antivirus_registration,
      attack_surface_reduction: windows.attack_surface_reduction
    },
    mac: {
      advanced: mac.advanced,
      events: mac.events,
      malware: mac.malware,
      behavior_protection: mac.behavior_protection,
      memory_protection: mac.memory_protection,
      popup: mac.popup
    },
    linux: {
      advanced: linux.advanced,
      events: linux.events,
      malware: linux.malware,
      behavior_protection: linux.behavior_protection,
      memory_protection: linux.memory_protection,
      popup: linux.popup
    }
  };
});
exports.policyConfig = policyConfig;
const isAntivirusRegistrationEnabled = (0, _reselect.createSelector)(policyConfig, uiPolicyConfig => {
  return uiPolicyConfig.windows.antivirus_registration.enabled;
});
exports.isAntivirusRegistrationEnabled = isAntivirusRegistrationEnabled;
const isCredentialHardeningEnabled = (0, _reselect.createSelector)(policyConfig, uiPolicyConfig => {
  return uiPolicyConfig.windows.attack_surface_reduction.credential_hardening.enabled;
});

/** is there an api call in flight */
exports.isCredentialHardeningEnabled = isCredentialHardeningEnabled;
const isLoading = state => state.isLoading;

/** API error when fetching Policy data */
exports.isLoading = isLoading;
const apiError = state => state.apiError;

/** Policy Agent Summary Stats */
exports.apiError = apiError;
const agentStatusSummary = state => state.agentStatusSummary;

/** Status for an update to the policy */
exports.agentStatusSummary = agentStatusSummary;
const updateStatus = state => state.updateStatus;
exports.updateStatus = updateStatus;