"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOnPolicyTrustedAppsView = exports.isOnPolicyFormView = exports.isOnPolicyEventFiltersView = exports.isOnHostIsolationExceptionsView = exports.isOnBlocklistsView = exports.getUrlLocationPathname = exports.getCurrentArtifactsLocation = void 0;
var _reactRouterDom = require("react-router-dom");
var _reselect = require("reselect");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns current artifacts location
 */
const getCurrentArtifactsLocation = state => state.artifacts.location;
exports.getCurrentArtifactsLocation = getCurrentArtifactsLocation;
const getUrlLocationPathname = state => {
  var _state$location;
  return (_state$location = state.location) === null || _state$location === void 0 ? void 0 : _state$location.pathname;
};

/** Returns a boolean of whether the user is on the policy form page or not */
exports.getUrlLocationPathname = getUrlLocationPathname;
const isOnPolicyFormView = (0, _reselect.createSelector)(getUrlLocationPathname, pathname => {
  return (0, _reactRouterDom.matchPath)(pathname !== null && pathname !== void 0 ? pathname : '', {
    path: _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_FORM_PATH,
    exact: true
  }) !== null;
});

/** Returns a boolean of whether the user is on the policy trusted apps page or not */
exports.isOnPolicyFormView = isOnPolicyFormView;
const isOnPolicyTrustedAppsView = (0, _reselect.createSelector)(getUrlLocationPathname, pathname => {
  return (0, _reactRouterDom.matchPath)(pathname !== null && pathname !== void 0 ? pathname : '', {
    path: _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_TRUSTED_APPS_PATH,
    exact: true
  }) !== null;
});

/** Returns a boolean of whether the user is on the policy event filters page or not */
exports.isOnPolicyTrustedAppsView = isOnPolicyTrustedAppsView;
const isOnPolicyEventFiltersView = (0, _reselect.createSelector)(getUrlLocationPathname, pathname => {
  return (0, _reactRouterDom.matchPath)(pathname !== null && pathname !== void 0 ? pathname : '', {
    path: _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_EVENT_FILTERS_PATH,
    exact: true
  }) !== null;
});

/** Returns a boolean of whether the user is on the host isolation exceptions page or not */
exports.isOnPolicyEventFiltersView = isOnPolicyEventFiltersView;
const isOnHostIsolationExceptionsView = (0, _reselect.createSelector)(getUrlLocationPathname, pathname => {
  return (0, _reactRouterDom.matchPath)(pathname !== null && pathname !== void 0 ? pathname : '', {
    path: _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_HOST_ISOLATION_EXCEPTIONS_PATH,
    exact: true
  }) !== null;
});

/** Returns a boolean of whether the user is on the blocklists page or not */
exports.isOnHostIsolationExceptionsView = isOnHostIsolationExceptionsView;
const isOnBlocklistsView = (0, _reselect.createSelector)(getUrlLocationPathname, pathname => {
  return (0, _reactRouterDom.matchPath)(pathname !== null && pathname !== void 0 ? pathname : '', {
    path: _constants.MANAGEMENT_ROUTING_POLICY_DETAILS_BLOCKLISTS_PATH,
    exact: true
  }) !== null;
});
exports.isOnBlocklistsView = isOnBlocklistsView;