"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NAME_PLACEHOLDER = exports.NAME_LABEL = exports.NAME_ERROR = exports.IP_PLACEHOLDER = exports.IP_LABEL = exports.IP_ERROR = exports.DESCRIPTION_PLACEHOLDER = exports.DESCRIPTION_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NAME_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.name.placeholder', {
  defaultMessage: 'Host isolation exception name'
});
exports.NAME_PLACEHOLDER = NAME_PLACEHOLDER;
const NAME_LABEL = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.name.label', {
  defaultMessage: 'Name your host isolation exceptions'
});
exports.NAME_LABEL = NAME_LABEL;
const NAME_ERROR = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.name.error', {
  defaultMessage: "The name can't be empty"
});
exports.NAME_ERROR = NAME_ERROR;
const DESCRIPTION_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.description.placeholder', {
  defaultMessage: 'Describe your host isolation exception'
});
exports.DESCRIPTION_PLACEHOLDER = DESCRIPTION_PLACEHOLDER;
const DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.description.label', {
  defaultMessage: 'Description'
});
exports.DESCRIPTION_LABEL = DESCRIPTION_LABEL;
const IP_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.ip.placeholder', {
  defaultMessage: 'Ex 0.0.0.0/24'
});
exports.IP_PLACEHOLDER = IP_PLACEHOLDER;
const IP_LABEL = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.ip.label', {
  defaultMessage: 'Enter IP Address'
});
exports.IP_LABEL = IP_LABEL;
const IP_ERROR = _i18n.i18n.translate('xpack.securitySolution.hostIsolationExceptions.form.ip.error', {
  defaultMessage: 'The IP is invalid. Only IPv4 with optional CIDR is supported'
});
exports.IP_ERROR = IP_ERROR;