"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostIsolationExceptionsContainer = void 0;
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _links = require("../../../common/links/links");
var _constants2 = require("../../common/constants");
var _ = require("../../../app/404");
var _host_isolation_exceptions_list = require("./view/host_isolation_exceptions_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides the routing container for the hosts related views
 */
const HostIsolationExceptionsContainer = /*#__PURE__*/(0, _react.memo)(() => {
  // TODO: Probably should not silently redirect here
  const canAccessHostIsolationExceptionsLink = (0, _links.useLinkExists)(_constants.SecurityPageName.hostIsolationExceptions);
  if (!canAccessHostIsolationExceptionsLink) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: _constants.ENDPOINTS_PATH
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH,
    exact: true,
    component: _host_isolation_exceptions_list.HostIsolationExceptionsList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    component: _.NotFoundPage
  }));
});
exports.HostIsolationExceptionsContainer = HostIsolationExceptionsContainer;
HostIsolationExceptionsContainer.displayName = 'HostIsolationExceptionsContainer';