"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reselect = require("reselect");
var _reactRedux = require("react-redux");
var _endpoint_agent_status = require("../../../../common/components/endpoint/endpoint_agent_status");
var _details = require("./details");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _hooks = require("./hooks");
var _utils = require("../utils");
var _host_constants = require("./host_constants");
var _use_navigate_by_router_event_handler = require("../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _constants = require("../../../common/constants");
var _management_empty_state = require("../../../components/management_empty_state");
var _formatted_date = require("../../../../common/components/formatted_date");
var _use_navigate_to_app_event_handler = require("../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _endpoint_policy_link = require("../../../components/endpoint_policy_link");
var _types = require("../../../../app/types");
var _routing = require("../../../common/routing");
var _link_to = require("../../../../common/components/link_to");
var _hooks2 = require("../../../../common/lib/kibana/hooks");
var _out_of_date = require("./components/out_of_date");
var _search_bar = require("./components/search_bar");
var _administration_list_page = require("../../../components/administration_list_page");
var _link_to_app = require("../../../../common/components/endpoint/link_to_app");
var _table_row_actions = require("./components/table_row_actions");
var _callouts = require("../../../../common/components/callouts");
var _constants2 = require("../../../../../common/endpoint/constants");
var _constants3 = require("../../../../../common/constants");
var _back_to_external_app_button = require("../../../components/back_to_external_app_button/back_to_external_app_button");
var _management_empty_state_wrapper = require("../../../components/management_empty_state_wrapper");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PAGINATED_ITEM = 9999;
const TRANSFORM_URL = '/data/transform';
const StyledDatePicker = _styledComponents.default.div`
  .euiFormControlLayout--group {
    background-color: rgba(0, 119, 204, 0.2);
  }

  .euiDatePickerRange--readOnly {
    background-color: ${props => props.theme.eui.euiFormBackgroundColor};
  }
`;
const EndpointListNavLink = /*#__PURE__*/(0, _react.memo)(({
  name,
  href,
  route,
  dataTestSubj
}) => {
  const clickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(route);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      "data-test-subj": dataTestSubj,
      className: "eui-displayInline eui-textTruncate",
      href: href,
      onClick: clickHandler
    }, name)
  );
});
EndpointListNavLink.displayName = 'EndpointListNavLink';

// FIXME: this needs refactoring - we are pulling in all selectors from endpoint, which includes many more than what the list uses
const selector = (0, _reselect.createStructuredSelector)(selectors);
const EndpointList = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    listData,
    pageIndex,
    pageSize,
    totalHits: totalItemCount,
    listLoading: loading,
    listError,
    uiQueryParams: queryParams,
    hasSelectedEndpoint,
    policyItems,
    selectedPolicyId,
    policyItemsLoading,
    endpointPackageVersion,
    endpointsExist,
    autoRefreshInterval,
    isAutoRefreshEnabled,
    patternsError,
    metadataTransformStats
  } = (0, _hooks.useEndpointSelector)(selector);
  const getHostPendingActions = (0, _hooks.useEndpointSelector)(selectors.getEndpointPendingActionsCallback);
  const {
    canReadEndpointList,
    canAccessFleet,
    canReadPolicyManagement,
    loading: endpointPrivilegesLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    search
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.administration);
  const {
    search: searchParams
  } = (0, _reactRouterDom.useLocation)();
  const {
    getAppUrl
  } = (0, _hooks2.useAppUrl)();
  const dispatch = (0, _reactRedux.useDispatch)();
  // cap ability to page at 10k records. (max_result_window)
  const maxPageCount = totalItemCount > MAX_PAGINATED_ITEM ? MAX_PAGINATED_ITEM : totalItemCount;
  const [showTransformFailedCallout, setShowTransformFailedCallout] = (0, _react.useState)(false);
  const [shouldCheckTransforms, setShouldCheckTransforms] = (0, _react.useState)(true);
  const {
    state: routeState = {}
  } = (0, _reactRouterDom.useLocation)();
  const backLinkOptions = (0, _react.useMemo)(() => {
    if (routeState !== null && routeState !== void 0 && routeState.backLink) {
      return {
        onBackButtonNavigateTo: routeState.backLink.navigateTo,
        backButtonLabel: routeState.backLink.label,
        backButtonUrl: routeState.backLink.href
      };
    }

    // default back button is to the policy list
    const policyListPath = (0, _routing.getPoliciesPath)();
    return {
      backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.backToPolicyButton', {
        defaultMessage: 'Back to policy list'
      }),
      backButtonUrl: getAppUrl({
        path: policyListPath
      }),
      onBackButtonNavigateTo: [_constants3.APP_UI_ID, {
        path: policyListPath
      }]
    };
  }, [getAppUrl, routeState === null || routeState === void 0 ? void 0 : routeState.backLink]);
  const backToPolicyList = /*#__PURE__*/_react.default.createElement(_back_to_external_app_button.BackToExternalAppButton, (0, _extends2.default)({}, backLinkOptions, {
    "data-test-subj": "endpointListBackLink"
  }));
  (0, _react.useEffect)(() => {
    // if no endpoint policy, skip transform check
    if (!shouldCheckTransforms || !policyItems || !policyItems.length) {
      return;
    }
    dispatch({
      type: 'loadMetadataTransformStats'
    });
    setShouldCheckTransforms(false);
  }, [policyItems, shouldCheckTransforms, dispatch]);
  (0, _react.useEffect)(() => {
    const hasFailure = metadataTransformStats.some(transform => _constants3.WARNING_TRANSFORM_STATES.has(transform === null || transform === void 0 ? void 0 : transform.state));
    setShowTransformFailedCallout(hasFailure);
  }, [metadataTransformStats]);
  const closeTransformFailedCallout = (0, _react.useCallback)(() => {
    setShowTransformFailedCallout(false);
  }, []);
  const paginationSetup = (0, _react.useMemo)(() => {
    return {
      pageIndex,
      pageSize,
      totalItemCount: maxPageCount,
      pageSizeOptions: [..._constants.MANAGEMENT_PAGE_SIZE_OPTIONS],
      showPerPageOptions: true
    };
  }, [pageIndex, pageSize, maxPageCount]);
  const onTableChange = (0, _react.useCallback)(({
    page
  }) => {
    const {
      index,
      size
    } = page;
    // FIXME: PT: if endpoint details is open, table is not displaying correct number of rows
    history.push((0, _routing.getEndpointListPath)({
      name: 'endpointList',
      ...queryParams,
      page_index: JSON.stringify(index),
      page_size: JSON.stringify(size)
    }));
  }, [history, queryParams]);
  const handleCreatePolicyClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)('fleet', {
    path: `/integrations/${endpointPackageVersion ? `/endpoint-${endpointPackageVersion}` : ''}/add-integration`,
    state: {
      onCancelNavigateTo: [_constants3.APP_UI_ID, {
        path: (0, _routing.getEndpointListPath)({
          name: 'endpointList'
        })
      }],
      onCancelUrl: getAppUrl({
        path: (0, _routing.getEndpointListPath)({
          name: 'endpointList'
        })
      }),
      onSaveNavigateTo: [_constants3.APP_UI_ID, {
        path: (0, _routing.getEndpointListPath)({
          name: 'endpointList'
        })
      }]
    }
  });
  const backToEndpointList = (0, _react.useMemo)(() => {
    const endpointListPath = (0, _routing.getEndpointListPath)({
      name: 'endpointList'
    }, searchParams);
    return {
      navigateTo: [_constants3.APP_UI_ID, {
        path: endpointListPath
      }],
      label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.backToListTitle', {
        defaultMessage: 'View all endpoints'
      }),
      href: getAppUrl({
        path: endpointListPath
      })
    };
  }, [getAppUrl, searchParams]);
  const onRefresh = (0, _react.useCallback)(() => {
    dispatch({
      type: 'appRequestedEndpointList'
    });
  }, [dispatch]);
  const onRefreshChange = (0, _react.useCallback)(evt => {
    dispatch({
      type: 'userUpdatedEndpointListRefreshOptions',
      payload: {
        isAutoRefreshEnabled: !evt.isPaused,
        autoRefreshInterval: evt.refreshInterval
      }
    });
  }, [dispatch]);
  const NOOP = (0, _react.useCallback)(() => {}, []);
  const PAD_LEFT = (0, _react.useMemo)(() => ({
    paddingLeft: '6px'
  }), []);
  const handleDeployEndpointsClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)('fleet', {
    path: `/policies/${selectedPolicyId}?openEnrollmentFlyout=true`,
    state: {
      onDoneNavigateTo: [_constants3.APP_UI_ID, {
        path: (0, _routing.getEndpointListPath)({
          name: 'endpointList'
        })
      }]
    }
  });
  const selectionOptions = (0, _react.useMemo)(() => {
    return policyItems.map(item => {
      return {
        key: item.policy_id,
        label: item.name,
        checked: selectedPolicyId === item.policy_id ? 'on' : undefined
      };
    });
  }, [policyItems, selectedPolicyId]);
  const handleSelectableOnChange = (0, _react.useCallback)(changedOptions => {
    return changedOptions.some(option => {
      if ('checked' in option && option.checked === 'on') {
        dispatch({
          type: 'userSelectedEndpointPolicy',
          payload: {
            selectedPolicyId: option.key
          }
        });
        return true;
      } else {
        return false;
      }
    });
  }, [dispatch]);
  const setTableRowProps = (0, _react.useCallback)(endpoint => {
    return {
      'data-endpoint-id': endpoint.metadata.agent.id
    };
  }, []);
  const columns = (0, _react.useMemo)(() => {
    const lastActiveColumnName = _i18n.i18n.translate('xpack.securitySolution.endpoint.list.lastActive', {
      defaultMessage: 'Last active'
    });
    return [{
      field: 'metadata',
      width: '15%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.hostname', {
        defaultMessage: 'Endpoint'
      }),
      render: ({
        host: {
          hostname
        },
        agent: {
          id
        }
      }) => {
        const toRoutePath = (0, _routing.getEndpointDetailsPath)({
          ...queryParams,
          name: 'endpointDetails',
          selected_endpoint: id
        }, search);
        const toRouteUrl = getAppUrl({
          path: toRoutePath
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: hostname,
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(EndpointListNavLink, {
          name: hostname,
          href: toRouteUrl,
          route: toRoutePath,
          dataTestSubj: "hostnameCellLink"
        }));
      }
    }, {
      field: 'host_status',
      width: '14%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.hostStatus', {
        defaultMessage: 'Agent status'
      }),
      render: (hostStatus, endpointInfo) => {
        return /*#__PURE__*/_react.default.createElement(_endpoint_agent_status.EndpointAgentStatus, {
          endpointHostInfo: endpointInfo,
          pendingActions: getHostPendingActions(endpointInfo.metadata.agent.id),
          "data-test-subj": "rowHostStatus"
        });
      }
    }, {
      field: 'metadata.Endpoint.policy.applied',
      width: '15%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.policy', {
        defaultMessage: 'Policy'
      }),
      truncateText: true,
      render: (policy, item) => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: policy.name,
          anchorClassName: "eui-textTruncate"
        }, canReadPolicyManagement ? /*#__PURE__*/_react.default.createElement(_endpoint_policy_link.EndpointPolicyLink, {
          policyId: policy.id,
          className: "eui-textTruncate",
          "data-test-subj": "policyNameCellLink",
          backLink: backToEndpointList
        }, policy.name) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, policy.name)), policy.endpoint_policy_version && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: "subdued",
          size: "xs",
          style: {
            whiteSpace: 'nowrap',
            ...PAD_LEFT
          },
          className: "eui-textTruncate",
          "data-test-subj": "policyListRevNo"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.list.policy.revisionNumber",
          defaultMessage: "rev. {revNumber}",
          values: {
            revNumber: policy.endpoint_policy_version
          }
        })), (0, _utils.isPolicyOutOfDate)(policy, item.policy_info) && /*#__PURE__*/_react.default.createElement(_out_of_date.OutOfDate, {
          style: PAD_LEFT,
          "data-test-subj": "rowPolicyOutOfDate"
        }));
      }
    }, {
      field: 'metadata.Endpoint.policy.applied',
      width: '9%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.policyStatus', {
        defaultMessage: 'Policy status'
      }),
      render: (policy, item) => {
        const toRoutePath = (0, _routing.getEndpointDetailsPath)({
          name: 'endpointPolicyResponse',
          ...queryParams,
          selected_endpoint: item.metadata.agent.id
        });
        const toRouteUrl = getAppUrl({
          path: toRoutePath
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: _host_constants.POLICY_STATUS_TO_TEXT[policy.status],
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: _host_constants.POLICY_STATUS_TO_HEALTH_COLOR[policy.status],
          className: "eui-textTruncate eui-fullWidth",
          "data-test-subj": "rowPolicyStatus"
        }, /*#__PURE__*/_react.default.createElement(EndpointListNavLink, {
          name: _host_constants.POLICY_STATUS_TO_TEXT[policy.status],
          href: toRouteUrl,
          route: toRoutePath,
          dataTestSubj: "policyStatusCellLink"
        })));
      }
    }, {
      field: 'metadata.host.os.name',
      width: '9%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.os', {
        defaultMessage: 'OS'
      }),
      render: os => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: os,
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          className: "eui-textTruncate eui-fullWidth"
        }, /*#__PURE__*/_react.default.createElement("p", {
          className: "eui-displayInline eui-TextTruncate"
        }, os)));
      }
    }, {
      field: 'metadata.host.ip',
      width: '12%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.ip', {
        defaultMessage: 'IP address'
      }),
      render: ip => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: ip.toString().replace(',', ', '),
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          className: "eui-textTruncate eui-fullWidth"
        }, /*#__PURE__*/_react.default.createElement("p", {
          className: "eui-displayInline eui-textTruncate"
        }, ip.toString().replace(',', ', '))));
      }
    }, {
      field: 'metadata.agent.version',
      width: '9%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.endpointVersion', {
        defaultMessage: 'Version'
      }),
      render: version => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: version,
          anchorClassName: "eui-textTruncate"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          className: "eui-textTruncate eui-fullWidth"
        }, /*#__PURE__*/_react.default.createElement("p", {
          className: "eui-displayInline eui-TextTruncate"
        }, version)));
      }
    }, {
      field: 'metadata.@timestamp',
      name: lastActiveColumnName,
      width: '9%',
      render(dateValue) {
        return /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
          fieldName: lastActiveColumnName,
          value: dateValue,
          className: "eui-textTruncate"
        });
      }
    }, {
      field: '',
      width: '8%',
      name: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.actions', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        render: item => {
          return /*#__PURE__*/_react.default.createElement(_table_row_actions.TableRowActions, {
            endpointMetadata: item.metadata
          });
        }
      }]
    }];
  }, [queryParams, search, getAppUrl, getHostPendingActions, canReadPolicyManagement, backToEndpointList, PAD_LEFT]);
  const renderTableOrEmptyState = (0, _react.useMemo)(() => {
    if (endpointsExist) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
        "data-test-subj": "endpointListTable",
        items: [...listData],
        columns: columns,
        error: listError === null || listError === void 0 ? void 0 : listError.message,
        pagination: paginationSetup,
        onChange: onTableChange,
        loading: loading,
        rowProps: setTableRowProps
      });
    } else if (canReadEndpointList && !canAccessFleet) {
      return /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, null, /*#__PURE__*/_react.default.createElement(_management_empty_state.PolicyEmptyState, {
        loading: endpointPrivilegesLoading
      }));
    } else if (!policyItemsLoading && policyItems && policyItems.length > 0) {
      return /*#__PURE__*/_react.default.createElement(_management_empty_state.HostsEmptyState, {
        loading: loading,
        onActionClick: handleDeployEndpointsClick,
        actionDisabled: selectedPolicyId === undefined,
        handleSelectableOnChange: handleSelectableOnChange,
        selectionOptions: selectionOptions
      });
    } else {
      return /*#__PURE__*/_react.default.createElement(_management_empty_state_wrapper.ManagementEmptyStateWrapper, null, /*#__PURE__*/_react.default.createElement(_management_empty_state.PolicyEmptyState, {
        loading: policyItemsLoading,
        onActionClick: handleCreatePolicyClick
      }));
    }
  }, [endpointsExist, policyItemsLoading, policyItems, listData, columns, listError === null || listError === void 0 ? void 0 : listError.message, paginationSetup, onTableChange, loading, setTableRowProps, handleDeployEndpointsClick, selectedPolicyId, handleSelectableOnChange, selectionOptions, handleCreatePolicyClick, canAccessFleet, canReadEndpointList, endpointPrivilegesLoading]);
  const hasListData = listData && listData.length > 0;
  const refreshStyle = (0, _react.useMemo)(() => {
    return {
      display: endpointsExist ? 'flex' : 'none',
      maxWidth: 200
    };
  }, [endpointsExist]);
  const refreshIsPaused = (0, _react.useMemo)(() => {
    return !endpointsExist ? false : hasSelectedEndpoint ? true : !isAutoRefreshEnabled;
  }, [endpointsExist, hasSelectedEndpoint, isAutoRefreshEnabled]);
  const refreshInterval = (0, _react.useMemo)(() => {
    return !endpointsExist ? _constants.DEFAULT_POLL_INTERVAL : autoRefreshInterval;
  }, [endpointsExist, autoRefreshInterval]);
  const shouldShowKQLBar = (0, _react.useMemo)(() => {
    return endpointsExist && !patternsError;
  }, [endpointsExist, patternsError]);
  const transformFailedCalloutDescription = (0, _react.useMemo)(() => {
    const failingTransformIds = metadataTransformStats.filter(transformStat => _constants3.WARNING_TRANSFORM_STATES.has(transformStat.state)).map(transformStat => transformStat.id).join(', ');
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.transformFailed.message",
      defaultMessage: "A required transform, {transformId}, is currently failing. Most of the time this can be fixed by {transformsPage}. For additional help, please visit the {docsPage}",
      values: {
        transformId: failingTransformIds || _constants2.metadataTransformPrefix,
        transformsPage: /*#__PURE__*/_react.default.createElement(_link_to_app.LinkToApp, {
          "data-test-subj": "failed-transform-restart-link",
          appId: "management",
          appPath: TRANSFORM_URL
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.list.transformFailed.restartLink",
          defaultMessage: "restarting the transform"
        })),
        docsPage: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "failed-transform-docs-link",
          href: services.docLinks.links.endpoints.troubleshooting,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.list.transformFailed.docsLink",
          defaultMessage: "troubleshooting documentation"
        }))
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }));
  }, [metadataTransformStats, services.docLinks.links.endpoints.troubleshooting]);
  const transformFailedCallout = (0, _react.useMemo)(() => {
    if (!showTransformFailedCallout) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_callouts.CallOut, {
      message: {
        id: 'endpoints-list-transform-failed',
        type: 'warning',
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.transformFailed.title', {
          defaultMessage: 'Required transform failed'
        }),
        description: transformFailedCalloutDescription
      },
      dismissButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.transformFailed.dismiss', {
        defaultMessage: 'Dismiss'
      }),
      onDismiss: closeTransformFailedCallout,
      showDismissButton: true
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }, [showTransformFailedCallout, closeTransformFailedCallout, transformFailedCalloutDescription]);
  return /*#__PURE__*/_react.default.createElement(_administration_list_page.AdministrationListPage, {
    "data-test-subj": "endpointPage",
    hideHeader: !endpointsExist,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.pageTitle",
      defaultMessage: "Endpoints"
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.pageSubTitle",
      defaultMessage: "Hosts running Elastic Defend"
    }),
    headerBackComponent: routeState.backLink && backToPolicyList
  }, hasSelectedEndpoint && /*#__PURE__*/_react.default.createElement(_details.EndpointDetailsFlyout, null), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, transformFailedCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, shouldShowKQLBar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_bar.AdminSearchBar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: refreshStyle
  }, /*#__PURE__*/_react.default.createElement(StyledDatePicker, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    className: "endpointListDatePicker",
    onTimeChange: NOOP,
    isDisabled: hasSelectedEndpoint,
    onRefresh: onRefresh,
    isPaused: refreshIsPaused,
    refreshInterval: refreshInterval,
    onRefreshChange: onRefreshChange,
    isAutoRefreshOnly: true
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), hasListData && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "endpointListTableTotal"
  }, totalItemCount > MAX_PAGINATED_ITEM + 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.list.totalCount.limited",
    defaultMessage: "Showing {limit} of {totalItemCount, plural, one {# endpoint} other {# endpoints}}",
    values: {
      totalItemCount,
      limit: MAX_PAGINATED_ITEM + 1
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.list.totalCount",
    defaultMessage: "Showing {totalItemCount, plural, one {# endpoint} other {# endpoints}}",
    values: {
      totalItemCount
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  })), renderTableOrEmptyState);
};
exports.EndpointList = EndpointList;