"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEndpointActionItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/fleet-plugin/public");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _hooks = require("../../../../hooks");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _constants = require("../../../../../../common/constants");
var _routing = require("../../../../common/routing");
var _hooks2 = require("./hooks");
var _selectors = require("../../store/selectors");
var _hooks3 = require("../../../../../common/lib/kibana/hooks");
var _validators = require("../../../../../common/utils/validators");
var _utils = require("../../../../../../common/endpoint/service/host_isolation/utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns a list (array) of actions for an individual endpoint
 * @param endpointMetadata
 */
const useEndpointActionItems = (endpointMetadata, options) => {
  const {
    getAppUrl
  } = (0, _hooks3.useAppUrl)();
  const fleetAgentPolicies = (0, _hooks2.useEndpointSelector)(_selectors.agentPolicies);
  const allCurrentUrlParams = (0, _hooks2.useEndpointSelector)(_selectors.uiQueryParams);
  const showEndpointResponseActionsConsole = (0, _hooks.useWithShowEndpointResponder)();
  const isResponseActionsConsoleEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsConsoleEnabled');
  const {
    canAccessResponseConsole,
    canIsolateHost,
    canUnIsolateHost,
    canAccessEndpointActionsLogManagement,
    canAccessFleet
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  return (0, _react.useMemo)(() => {
    if (endpointMetadata) {
      const isIsolated = (0, _validators.isEndpointHostIsolated)(endpointMetadata);
      const endpointId = endpointMetadata.agent.id;
      const endpointPolicyId = endpointMetadata.Endpoint.policy.applied.id;
      const endpointHostName = endpointMetadata.host.hostname;
      const fleetAgentId = endpointMetadata.elastic.agent.id;
      const isolationSupported = (0, _utils.isIsolationSupported)({
        osName: endpointMetadata.host.os.name,
        version: endpointMetadata.agent.version,
        capabilities: endpointMetadata.Endpoint.capabilities
      });
      const {
        show,
        selected_endpoint: _selectedEndpoint,
        ...currentUrlParams
      } = allCurrentUrlParams;
      const endpointActionsPath = (0, _routing.getEndpointDetailsPath)({
        name: 'endpointActivityLog',
        ...currentUrlParams,
        selected_endpoint: endpointId
      });
      const endpointIsolatePath = (0, _routing.getEndpointDetailsPath)({
        name: 'endpointIsolate',
        ...currentUrlParams,
        selected_endpoint: endpointId
      });
      const endpointUnIsolatePath = (0, _routing.getEndpointDetailsPath)({
        name: 'endpointUnIsolate',
        ...currentUrlParams,
        selected_endpoint: endpointId
      });
      const isolationActions = [];
      if (isIsolated && canUnIsolateHost) {
        // Un-isolate is available to users regardless of license level if they have unisolate permissions
        isolationActions.push({
          'data-test-subj': 'unIsolateLink',
          icon: 'lockOpen',
          key: 'unIsolateHost',
          navigateAppId: _constants.APP_UI_ID,
          navigateOptions: {
            path: endpointUnIsolatePath
          },
          href: getAppUrl({
            path: endpointUnIsolatePath
          }),
          children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.endpoint.actions.unIsolateHost",
            defaultMessage: "Release host"
          })
        });
      } else if (isolationSupported && canIsolateHost) {
        // For Platinum++ licenses, users also have ability to isolate
        isolationActions.push({
          'data-test-subj': 'isolateLink',
          icon: 'lock',
          key: 'isolateHost',
          navigateAppId: _constants.APP_UI_ID,
          navigateOptions: {
            path: endpointIsolatePath
          },
          href: getAppUrl({
            path: endpointIsolatePath
          }),
          children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.endpoint.actions.isolateHost",
            defaultMessage: "Isolate host"
          })
        });
      }
      return [...isolationActions, ...(isResponseActionsConsoleEnabled && canAccessResponseConsole ? [{
        'data-test-subj': 'console',
        icon: 'console',
        key: 'consoleLink',
        onClick: ev => {
          ev.preventDefault();
          showEndpointResponseActionsConsole(endpointMetadata);
        },
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.console",
          defaultMessage: "Respond"
        })
      }] : []), ...(options !== null && options !== void 0 && options.isEndpointList && canAccessEndpointActionsLogManagement ? [{
        'data-test-subj': 'actionsLink',
        icon: 'logoSecurity',
        key: 'actionsLogLink',
        navigateAppId: _constants.APP_UI_ID,
        navigateOptions: {
          path: endpointActionsPath
        },
        href: getAppUrl({
          path: endpointActionsPath
        }),
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.responseActionsHistory",
          defaultMessage: "View response actions history"
        })
      }] : []), {
        'data-test-subj': 'hostLink',
        icon: 'logoSecurity',
        key: 'hostDetailsLink',
        navigateAppId: _constants.APP_UI_ID,
        navigateOptions: {
          path: `/hosts/${endpointHostName}`
        },
        href: getAppUrl({
          path: `/hosts/${endpointHostName}`
        }),
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.hostDetails",
          defaultMessage: "View host details"
        })
      }, ...(canAccessFleet ? [{
        icon: 'gear',
        key: 'agentConfigLink',
        'data-test-subj': 'agentPolicyLink',
        navigateAppId: 'fleet',
        navigateOptions: {
          path: `${_public.pagePathGetters.policy_details({
            policyId: fleetAgentPolicies[endpointPolicyId]
          })[1]}`
        },
        href: `${getAppUrl({
          appId: 'fleet'
        })}${_public.pagePathGetters.policy_details({
          policyId: fleetAgentPolicies[endpointPolicyId]
        })[1]}`,
        disabled: fleetAgentPolicies[endpointPolicyId] === undefined,
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.agentPolicy",
          defaultMessage: "View agent policy"
        })
      }, {
        icon: 'gear',
        key: 'agentDetailsLink',
        'data-test-subj': 'agentDetailsLink',
        navigateAppId: 'fleet',
        navigateOptions: {
          path: `${_public.pagePathGetters.agent_details({
            agentId: fleetAgentId
          })[1]}`
        },
        href: `${getAppUrl({
          appId: 'fleet'
        })}${_public.pagePathGetters.agent_details({
          agentId: fleetAgentId
        })[1]}`,
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.agentDetails",
          defaultMessage: "View agent details"
        })
      }, {
        icon: 'gear',
        key: 'agentPolicyReassignLink',
        'data-test-subj': 'agentPolicyReassignLink',
        navigateAppId: 'fleet',
        navigateOptions: {
          path: `${_public.pagePathGetters.agent_details({
            agentId: fleetAgentId
          })[1]}?openReassignFlyout=true`,
          state: {
            onDoneNavigateTo: [_constants.APP_UI_ID, {
              path: (0, _routing.getEndpointListPath)({
                name: 'endpointList'
              })
            }]
          }
        },
        href: `${getAppUrl({
          appId: 'fleet'
        })}${_public.pagePathGetters.agent_details({
          agentId: fleetAgentId
        })[1]}?openReassignFlyout=true`,
        children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.actions.agentPolicyReassign",
          defaultMessage: "Reassign agent policy"
        })
      }] : [])];
    }
    return [];
  }, [allCurrentUrlParams, canAccessResponseConsole, canAccessEndpointActionsLogManagement, endpointMetadata, fleetAgentPolicies, getAppUrl, isResponseActionsConsoleEnabled, showEndpointResponseActionsConsole, options === null || options === void 0 ? void 0 : options.isEndpointList, canIsolateHost, canUnIsolateHost, canAccessFleet]);
};
exports.useEndpointActionItems = useEndpointActionItems;