"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetails = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _user_privileges = require("../../../../../common/components/user_privileges");
var _response_actions_log = require("../../../../components/endpoint_response_actions_list/response_actions_log");
var _policy_response = require("../../../../components/policy_response");
var _kibana = require("../../../../../common/lib/kibana");
var _routing = require("../../../../common/routing");
var _selectors = require("../../store/selectors");
var _hooks = require("../hooks");
var i18 = _interopRequireWildcard(require("../translations"));
var _actions_menu = require("./components/actions_menu");
var _endpoint_details_tabs = require("./components/endpoint_details_tabs");
var _endpoint_isolate_flyout_panel = require("./components/endpoint_isolate_flyout_panel");
var _flyout_header = require("./components/flyout_header");
var _endpoint_details_content = require("./endpoint_details_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointDetails = /*#__PURE__*/(0, _react.memo)(() => {
  var _hostDetails$host;
  const toasts = (0, _kibana.useToasts)();
  const queryParams = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const hostDetails = (0, _hooks.useEndpointSelector)(_selectors.detailsData);
  const hostDetailsError = (0, _hooks.useEndpointSelector)(_selectors.detailsError);
  const policyInfo = (0, _hooks.useEndpointSelector)(_selectors.policyVersionInfo);
  const hostStatus = (0, _hooks.useEndpointSelector)(_selectors.hostStatusInfo);
  const show = (0, _hooks.useEndpointSelector)(_selectors.showView);
  const {
    canAccessEndpointActionsLogManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const ContentLoadingMarkup = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 3
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 3
  })), []);
  const getTabs = (0, _react.useCallback)(id => {
    const tabs = [{
      id: _endpoint_details_tabs.EndpointDetailsTabsTypes.overview,
      name: i18.OVERVIEW,
      route: (0, _routing.getEndpointDetailsPath)({
        ...queryParams,
        name: 'endpointDetails',
        selected_endpoint: id
      }),
      content: hostDetails === undefined ? ContentLoadingMarkup : /*#__PURE__*/_react.default.createElement(_endpoint_details_content.EndpointDetailsContent, {
        details: hostDetails,
        policyInfo: policyInfo,
        hostStatus: hostStatus
      })
    }];

    // show the response actions history tab
    // only when the user has the required permission
    if (canAccessEndpointActionsLogManagement) {
      tabs.push({
        id: _endpoint_details_tabs.EndpointDetailsTabsTypes.activityLog,
        name: i18.ACTIVITY_LOG.tabTitle,
        route: (0, _routing.getEndpointDetailsPath)({
          ...queryParams,
          name: 'endpointActivityLog',
          selected_endpoint: id
        }),
        content: /*#__PURE__*/_react.default.createElement(_response_actions_log.ResponseActionsLog, {
          agentIds: id
        })
      });
    }
    return tabs;
  }, [canAccessEndpointActionsLogManagement, ContentLoadingMarkup, hostDetails, policyInfo, hostStatus, queryParams]);
  const showFlyoutFooter = show === 'details' || show === 'policy_response' || show === 'activity_log';
  (0, _react.useEffect)(() => {
    if (hostDetailsError !== undefined) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.errorTitle', {
          defaultMessage: 'Could not find host'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.errorBody', {
          defaultMessage: 'Please exit the flyout and select an available host.'
        })
      });
    }
  }, [hostDetailsError, show, toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (show === 'policy_response' || show === 'isolate' || show === 'unisolate') && /*#__PURE__*/_react.default.createElement(_flyout_header.EndpointDetailsFlyoutHeader, {
    hasBorder: true,
    endpointId: hostDetails === null || hostDetails === void 0 ? void 0 : hostDetails.agent.id,
    hostname: hostDetails === null || hostDetails === void 0 ? void 0 : (_hostDetails$host = hostDetails.host) === null || _hostDetails$host === void 0 ? void 0 : _hostDetails$host.hostname
  }), hostDetails === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 3
  }), " ", /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), " ", /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
    lines: 3
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (show === 'details' || show === 'activity_log') && /*#__PURE__*/_react.default.createElement(_endpoint_details_tabs.EndpointDetailsFlyoutTabs, {
    hostname: hostDetails.host.hostname
    // show overview tab if forcing response actions history
    // tab via URL without permission
    ,
    show: !canAccessEndpointActionsLogManagement ? 'details' : show,
    tabs: getTabs(hostDetails.agent.id)
  }), show === 'policy_response' && /*#__PURE__*/_react.default.createElement(PolicyResponseFlyoutPanel, {
    hostMeta: hostDetails
  }), (show === 'isolate' || show === 'unisolate') && /*#__PURE__*/_react.default.createElement(_endpoint_isolate_flyout_panel.EndpointIsolationFlyoutPanel, {
    hostMeta: hostDetails
  }), showFlyoutFooter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "eui-textRight",
    "data-test-subj": "endpointDetailsFlyoutFooter"
  }, /*#__PURE__*/_react.default.createElement(_actions_menu.ActionsMenu, null))));
});
exports.EndpointDetails = EndpointDetails;
EndpointDetails.displayName = 'EndpointDetails';
const PolicyResponseFlyoutPanel = /*#__PURE__*/(0, _react.memo)(({
  hostMeta
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "endpointDetailsPolicyResponseFlyoutBody",
    className: "endpointDetailsPolicyResponseFlyoutBody"
  }, /*#__PURE__*/_react.default.createElement(_policy_response.PolicyResponseWrapper, {
    endpointId: hostMeta.agent.id
  })));
});
PolicyResponseFlyoutPanel.displayName = 'PolicyResponseFlyoutPanel';