"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointIsolationFlyoutPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _host_isolation = require("../../../../../../common/components/endpoint/host_isolation");
var _routing = require("../../../../../common/routing");
var _hooks = require("../../hooks");
var _selectors = require("../../../store/selectors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component handles both isolate and un-isolate for a given endpoint
 */
const EndpointIsolationFlyoutPanel = /*#__PURE__*/(0, _react.memo)(({
  hostMeta
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    show,
    ...queryParams
  } = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const isCurrentlyIsolated = (0, _hooks.useEndpointSelector)(_selectors.getIsEndpointHostIsolated);
  const isPending = (0, _hooks.useEndpointSelector)(_selectors.getIsIsolationRequestPending);
  const wasSuccessful = (0, _hooks.useEndpointSelector)(_selectors.getWasIsolationRequestSuccessful);
  const isolateError = (0, _hooks.useEndpointSelector)(_selectors.getIsolationRequestError);
  const [formValues, setFormValues] = (0, _react.useState)({
    comment: ''
  });
  const IsolationForm = isCurrentlyIsolated ? _host_isolation.EndpointUnisolateForm : _host_isolation.EndpointIsolateForm;
  const handleCancel = (0, _react.useCallback)(() => {
    history.push((0, _routing.getEndpointDetailsPath)({
      name: 'endpointDetails',
      ...queryParams,
      selected_endpoint: hostMeta.agent.id
    }));
  }, [history, hostMeta.agent.id, queryParams]);
  const handleConfirm = (0, _react.useCallback)(() => {
    dispatch({
      type: 'endpointIsolationRequest',
      payload: {
        type: isCurrentlyIsolated ? 'unisolate' : 'isolate',
        data: {
          endpoint_ids: [hostMeta.agent.id],
          comment: formValues.comment
        }
      }
    });
  }, [dispatch, formValues.comment, hostMeta.agent.id, isCurrentlyIsolated]);
  const handleChange = (0, _react.useCallback)(changes => {
    setFormValues(prevState => {
      return {
        ...prevState,
        ...changes
      };
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, wasSuccessful && /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointIsolateSuccess, {
    hostName: hostMeta.host.name,
    isolateAction: isCurrentlyIsolated ? 'unisolateHost' : 'isolateHost'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, wasSuccessful ? /*#__PURE__*/_react.default.createElement(_host_isolation.ActionCompletionReturnButton, {
    onClick: handleCancel,
    buttonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.successProceedButton', {
      defaultMessage: 'Return to endpoint details'
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    isInvalid: !!isolateError,
    error: isolateError === null || isolateError === void 0 ? void 0 : isolateError.message,
    "data-test-subj": "endpointIsolationForm"
  }, /*#__PURE__*/_react.default.createElement(IsolationForm, {
    comment: formValues.comment,
    isLoading: isPending,
    hostName: hostMeta.host.name,
    onCancel: handleCancel,
    onConfirm: handleConfirm,
    onChange: handleChange
  }))));
});
exports.EndpointIsolationFlyoutPanel = EndpointIsolationFlyoutPanel;
EndpointIsolationFlyoutPanel.displayName = 'EndpointIsolateFlyoutPanel';