"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetailsTabsTypes = exports.EndpointDetailsFlyoutTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _flyout_header = require("./flyout_header");
var _use_navigate_by_router_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _kibana = require("../../../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let EndpointDetailsTabsTypes;
exports.EndpointDetailsTabsTypes = EndpointDetailsTabsTypes;
(function (EndpointDetailsTabsTypes) {
  EndpointDetailsTabsTypes["overview"] = "details";
  EndpointDetailsTabsTypes["activityLog"] = "activity_log";
})(EndpointDetailsTabsTypes || (exports.EndpointDetailsTabsTypes = EndpointDetailsTabsTypes = {}));
const EndpointDetailsTab = /*#__PURE__*/(0, _react.memo)(({
  tab,
  isSelected
}) => {
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const onClick = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(tab.route);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    href: getAppUrl({
      path: tab.route
    }),
    onClick: onClick,
    isSelected: isSelected,
    key: tab.id,
    "data-test-subj": `endpoint-details-flyout-tab-${tab.id}`
  }, tab.name);
});
EndpointDetailsTab.displayName = 'EndpointDetailsTab';
const EndpointDetailsFlyoutTabs = /*#__PURE__*/(0, _react.memo)(({
  hostname,
  show,
  tabs
}) => {
  const selectedTab = (0, _react.useMemo)(() => tabs.find(tab => tab.id === show), [tabs, show]);
  const renderTabs = tabs.map(tab => /*#__PURE__*/_react.default.createElement(EndpointDetailsTab, {
    key: tab.id,
    tab: tab,
    isSelected: tab.id === (selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.id)
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_header.EndpointDetailsFlyoutHeader, {
    hostname: hostname,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false,
    style: {
      marginBottom: '-25px'
    }
  }, renderTabs)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": `endpoint${(selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.id) === 'details' ? 'Details' : 'ActivityLog'}FlyoutBody`
  }, selectedTab === null || selectedTab === void 0 ? void 0 : selectedTab.content));
});
exports.EndpointDetailsFlyoutTabs = EndpointDetailsFlyoutTabs;
EndpointDetailsFlyoutTabs.displayName = 'EndpointDetailsFlyoutTabs';