"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToEndpointDetailsFlyoutSubHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _routing = require("../../../../../common/routing");
var _use_navigate_by_router_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
var _hooks = require("../../hooks");
var _selectors = require("../../../store/selectors");
var _hooks2 = require("../../../../../../common/lib/kibana/hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BackToEndpointDetailsFlyoutSubHeader = /*#__PURE__*/(0, _react.memo)(({
  endpointId
}) => {
  var _backButtonProps$href;
  const {
    getAppUrl
  } = (0, _hooks2.useAppUrl)();
  const {
    show,
    ...currentUrlQueryParams
  } = (0, _hooks.useEndpointSelector)(_selectors.uiQueryParams);
  const detailsRoutePath = (0, _react.useMemo)(() => (0, _routing.getEndpointDetailsPath)({
    name: 'endpointDetails',
    ...currentUrlQueryParams,
    selected_endpoint: endpointId
  }), [currentUrlQueryParams, endpointId]);
  const backToDetailsClickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(detailsRoutePath);
  const backButtonProps = (0, _react.useMemo)(() => {
    return {
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyResponse.backLinkTitle', {
        defaultMessage: 'Endpoint details'
      }),
      href: getAppUrl({
        path: detailsRoutePath
      }),
      onClick: backToDetailsClickHandler
    };
  }, [backToDetailsClickHandler, getAppUrl, detailsRoutePath]);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    "data-test-subj": "flyoutSubHeaderBackButton",
    iconType: "arrowLeft",
    size: "xs",
    href: (_backButtonProps$href = backButtonProps === null || backButtonProps === void 0 ? void 0 : backButtonProps.href) !== null && _backButtonProps$href !== void 0 ? _backButtonProps$href : '',
    onClick: backButtonProps === null || backButtonProps === void 0 ? void 0 : backButtonProps.onClick
  }, backButtonProps === null || backButtonProps === void 0 ? void 0 : backButtonProps.title));
});
exports.BackToEndpointDetailsFlyoutSubHeader = BackToEndpointDetailsFlyoutSubHeader;
BackToEndpointDetailsFlyoutSubHeader.displayName = 'BackToEndpointDetailsFlyoutSubHeader';