"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFailedOrWarningActionCountFromPolicyResponse = void 0;
var _types = require("../../../../../common/endpoint/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFailedOrWarningActionCountFromPolicyResponse = applied => {
  var _applied$response;
  const failureOrWarningByConfigType = new Map();
  if ((applied === null || applied === void 0 ? void 0 : (_applied$response = applied.response) === null || _applied$response === void 0 ? void 0 : _applied$response.configurations) !== undefined && (applied === null || applied === void 0 ? void 0 : applied.actions) !== undefined) {
    Object.entries(applied.response.configurations).map(([key, val]) => {
      let count = 0;
      for (const action of val.concerned_actions) {
        var _applied$actions$find;
        const actionStatus = (_applied$actions$find = applied.actions.find(policyActions => policyActions.name === action)) === null || _applied$actions$find === void 0 ? void 0 : _applied$actions$find.status;
        if (actionStatus === _types.HostPolicyResponseActionStatus.failure || actionStatus === _types.HostPolicyResponseActionStatus.warning) {
          count += 1;
        }
      }
      return failureOrWarningByConfigType.set(key, count);
    });
  }
  return failureOrWarningByConfigType;
};
exports.getFailedOrWarningActionCountFromPolicyResponse = getFailedOrWarningActionCountFromPolicyResponse;