"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uiQueryParams = exports.totalHits = exports.showView = exports.selectedPolicyId = exports.searchBarQuery = exports.policyVersionInfo = exports.policyResponseStatus = exports.policyItemsLoading = exports.policyItems = exports.patternsError = exports.patterns = exports.pageSize = exports.pageIndex = exports.nonExistingPolicies = exports.metadataTransformStats = exports.listLoading = exports.listError = exports.listData = exports.isOnEndpointPage = exports.isMetadataTransformStatsLoading = exports.isAutoRefreshEnabled = exports.hostStatusInfo = exports.hasSelectedEndpoint = exports.getWasIsolationRequestSuccessful = exports.getMetadataTransformStats = exports.getIsolationRequestError = exports.getIsOnEndpointDetailsActivityLog = exports.getIsIsolationRequestPending = exports.getIsEndpointPackageInfoUninitialized = exports.getIsEndpointHostIsolated = exports.getEndpointPendingActionsState = exports.getEndpointPendingActionsCallback = exports.getCurrentIsolationRequestState = exports.fullDetailsHostInfo = exports.endpointsExist = exports.endpointPackageVersion = exports.endpointPackageInfo = exports.detailsLoading = exports.detailsError = exports.detailsData = exports.autoRefreshInterval = exports.agentPolicies = void 0;
var _querystring = _interopRequireDefault(require("querystring"));
var _reselect = require("reselect");
var _reactRouterDom = require("react-router-dom");
var _rison = require("@kbn/rison");
var _types = require("../../../../../common/endpoint/types");
var _routing = require("../../../common/routing");
var _constants = require("../../../common/constants");
var _state = require("../../../state");
var _validators = require("../../../../common/utils/validators");
var _endpoint_details_tabs = require("../view/details/components/endpoint_details_tabs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-nodejs-modules

const listData = state => state.hosts;
exports.listData = listData;
const pageIndex = state => state.pageIndex;
exports.pageIndex = pageIndex;
const pageSize = state => state.pageSize;
exports.pageSize = pageSize;
const totalHits = state => state.total;
exports.totalHits = totalHits;
const listLoading = state => state.loading;
exports.listLoading = listLoading;
const listError = state => state.error;
exports.listError = listError;
const detailsData = state => state.endpointDetails.hostDetails.details;
exports.detailsData = detailsData;
const fullDetailsHostInfo = state => state.endpointDetails.hostInfo;
exports.fullDetailsHostInfo = fullDetailsHostInfo;
const detailsLoading = state => state.endpointDetails.hostDetails.detailsLoading;
exports.detailsLoading = detailsLoading;
const detailsError = state => state.endpointDetails.hostDetails.detailsError;
exports.detailsError = detailsError;
const policyItems = state => state.policyItems;
exports.policyItems = policyItems;
const policyItemsLoading = state => state.policyItemsLoading;
exports.policyItemsLoading = policyItemsLoading;
const selectedPolicyId = state => state.selectedPolicyId;
exports.selectedPolicyId = selectedPolicyId;
const endpointPackageInfo = state => state.endpointPackageInfo;
exports.endpointPackageInfo = endpointPackageInfo;
const getIsEndpointPackageInfoUninitialized = (0, _reselect.createSelector)(endpointPackageInfo, packageInfo => (0, _state.isUninitialisedResourceState)(packageInfo));
exports.getIsEndpointPackageInfoUninitialized = getIsEndpointPackageInfoUninitialized;
const isAutoRefreshEnabled = state => state.isAutoRefreshEnabled;
exports.isAutoRefreshEnabled = isAutoRefreshEnabled;
const autoRefreshInterval = state => state.autoRefreshInterval;
exports.autoRefreshInterval = autoRefreshInterval;
const policyVersionInfo = state => state.policyVersionInfo;
exports.policyVersionInfo = policyVersionInfo;
const endpointPackageVersion = (0, _reselect.createSelector)(endpointPackageInfo, info => (0, _state.isLoadedResourceState)(info) ? info.data.version : undefined);

/**
 * Returns the index patterns for the SearchBar to use for autosuggest
 */
exports.endpointPackageVersion = endpointPackageVersion;
const patterns = state => state.patterns;
exports.patterns = patterns;
const patternsError = state => state.patternsError;
exports.patternsError = patternsError;
const isOnEndpointPage = state => {
  var _state$location$pathn, _state$location;
  return (0, _reactRouterDom.matchPath)((_state$location$pathn = (_state$location = state.location) === null || _state$location === void 0 ? void 0 : _state$location.pathname) !== null && _state$location$pathn !== void 0 ? _state$location$pathn : '', {
    path: _constants.MANAGEMENT_ROUTING_ENDPOINTS_PATH,
    exact: true
  }) !== null;
};

/** Sanitized list of URL query params supported by the Details page */
exports.isOnEndpointPage = isOnEndpointPage;
const uiQueryParams = (0, _reselect.createSelector)(state => state.location, location => {
  const data = {
    page_index: String(_constants.MANAGEMENT_DEFAULT_PAGE),
    page_size: String(_constants.MANAGEMENT_DEFAULT_PAGE_SIZE)
  };
  if (location) {
    // Removes the `?` from the beginning of query string if it exists
    const query = _querystring.default.parse(location.search.slice(1));
    const paginationParams = (0, _routing.extractListPaginationParams)(query);
    const keys = ['selected_endpoint', 'show', 'admin_query'];
    const allowedShowValues = ['policy_response', 'details', 'isolate', 'unisolate', 'activity_log'];
    for (const key of keys) {
      const value = typeof query[key] === 'string' ? query[key] : Array.isArray(query[key]) ? query[key][query[key].length - 1] : undefined;
      if (value !== undefined) {
        if (key === 'show') {
          if (allowedShowValues.includes(value)) {
            data[key] = value;
          }
        } else {
          data[key] = value;
        }
      }
    }
    data.page_size = String(paginationParams.page_size);
    data.page_index = String(paginationParams.page_index);
  }
  return data;
});
exports.uiQueryParams = uiQueryParams;
const hasSelectedEndpoint = (0, _reselect.createSelector)(uiQueryParams, ({
  selected_endpoint: selectedEndpoint
}) => {
  return selectedEndpoint !== undefined;
});

/** What policy details panel view to show */
exports.hasSelectedEndpoint = hasSelectedEndpoint;
const showView = (0, _reselect.createSelector)(uiQueryParams, searchParams => {
  var _searchParams$show;
  return (_searchParams$show = searchParams.show) !== null && _searchParams$show !== void 0 ? _searchParams$show : 'details';
});

/**
 * Returns the Host Status which is connected the fleet agent
 */
exports.showView = showView;
const hostStatusInfo = (0, _reselect.createSelector)(state => state.hostStatus, hostStatus => {
  return hostStatus ? hostStatus : _types.HostStatus.UNHEALTHY;
});

/**
 * Returns the Policy Response overall status
 */
exports.hostStatusInfo = hostStatusInfo;
const policyResponseStatus = (0, _reselect.createSelector)(state => state.policyResponse, policyResponse => {
  var _policyResponse$Endpo, _policyResponse$Endpo2, _policyResponse$Endpo3;
  return policyResponse && (policyResponse === null || policyResponse === void 0 ? void 0 : (_policyResponse$Endpo = policyResponse.Endpoint) === null || _policyResponse$Endpo === void 0 ? void 0 : (_policyResponse$Endpo2 = _policyResponse$Endpo.policy) === null || _policyResponse$Endpo2 === void 0 ? void 0 : (_policyResponse$Endpo3 = _policyResponse$Endpo2.applied) === null || _policyResponse$Endpo3 === void 0 ? void 0 : _policyResponse$Endpo3.status) || '';
});

/**
 * returns the list of known non-existing polices that may have been in the Endpoint API response.
 * @param state
 */
exports.policyResponseStatus = policyResponseStatus;
const nonExistingPolicies = state => state.nonExistingPolicies;

/**
 * returns the list of known existing agent policies
 */
exports.nonExistingPolicies = nonExistingPolicies;
const agentPolicies = state => state.agentPolicies;

/**
 * Return boolean that indicates whether endpoints exist
 * @param state
 */
exports.agentPolicies = agentPolicies;
const endpointsExist = state => state.endpointsExist;

/**
 * Returns query text from query bar
 */
exports.endpointsExist = endpointsExist;
const searchBarQuery = (0, _reselect.createSelector)(uiQueryParams, ({
  admin_query: adminQuery
}) => {
  const decodedQuery = {
    query: '',
    language: 'kuery'
  };
  if (adminQuery) {
    const urlDecodedQuery = (0, _rison.decode)(adminQuery);
    if (urlDecodedQuery && typeof urlDecodedQuery.query === 'string') {
      decodedQuery.query = urlDecodedQuery.query;
    }
    if (urlDecodedQuery && typeof urlDecodedQuery.language === 'string' && (urlDecodedQuery.language === 'kuery' || urlDecodedQuery.language === 'lucene')) {
      decodedQuery.language = urlDecodedQuery.language;
    }
  }
  return decodedQuery;
});
exports.searchBarQuery = searchBarQuery;
const getCurrentIsolationRequestState = state => {
  return state.isolationRequestState;
};
exports.getCurrentIsolationRequestState = getCurrentIsolationRequestState;
const getIsIsolationRequestPending = (0, _reselect.createSelector)(getCurrentIsolationRequestState, isolateHost => (0, _state.isLoadingResourceState)(isolateHost));
exports.getIsIsolationRequestPending = getIsIsolationRequestPending;
const getWasIsolationRequestSuccessful = (0, _reselect.createSelector)(getCurrentIsolationRequestState, isolateHost => (0, _state.isLoadedResourceState)(isolateHost));
exports.getWasIsolationRequestSuccessful = getWasIsolationRequestSuccessful;
const getIsolationRequestError = (0, _reselect.createSelector)(getCurrentIsolationRequestState, isolateHost => {
  if ((0, _state.isFailedResourceState)(isolateHost)) {
    return isolateHost.error;
  }
});
exports.getIsolationRequestError = getIsolationRequestError;
const getIsOnEndpointDetailsActivityLog = (0, _reselect.createSelector)(uiQueryParams, searchParams => {
  return searchParams.show === _endpoint_details_tabs.EndpointDetailsTabsTypes.activityLog;
});
exports.getIsOnEndpointDetailsActivityLog = getIsOnEndpointDetailsActivityLog;
const getIsEndpointHostIsolated = (0, _reselect.createSelector)(detailsData, details => {
  return details && (0, _validators.isEndpointHostIsolated)(details) || false;
});
exports.getIsEndpointHostIsolated = getIsEndpointHostIsolated;
const getEndpointPendingActionsState = state => {
  return state.endpointPendingActions;
};
exports.getEndpointPendingActionsState = getEndpointPendingActionsState;
const getMetadataTransformStats = state => state.metadataTransformStats;
exports.getMetadataTransformStats = getMetadataTransformStats;
const metadataTransformStats = state => (0, _state.isLoadedResourceState)(state.metadataTransformStats) ? state.metadataTransformStats.data : [];
exports.metadataTransformStats = metadataTransformStats;
const isMetadataTransformStatsLoading = state => (0, _state.isLoadingResourceState)(state.metadataTransformStats);

/**
 * Returns a function (callback) that can be used to retrieve the list of pending actions against
 * an endpoint currently displayed in the endpoint list
 */
exports.isMetadataTransformStatsLoading = isMetadataTransformStatsLoading;
const getEndpointPendingActionsCallback = (0, _reselect.createSelector)(getEndpointPendingActionsState, pendingActionsState => {
  return endpointId => {
    let response = {};
    if ((0, _state.isLoadedResourceState)(pendingActionsState)) {
      var _pendingActionsState$;
      response = (_pendingActionsState$ = pendingActionsState.data.get(endpointId)) !== null && _pendingActionsState$ !== void 0 ? _pendingActionsState$ : {};
    }
    return response;
  };
});
exports.getEndpointPendingActionsCallback = getEndpointPendingActionsCallback;