"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = exports.getManagementFilteredLinks = void 0;
var _i18n = require("@kbn/i18n");
var _authz = require("../../common/endpoint/service/authz/authz");
var _check_artifact_has_data = require("./services/exceptions_list/check_artifact_has_data");
var _authz2 = require("../../common/endpoint/service/authz");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
var _use_license = require("../common/hooks/use_license");
var _links = require("../cloud_security_posture/links");
var _links2 = require("../cloud_defend/links");
var _action_history = require("./icons/action_history");
var _blocklist = require("./icons/blocklist");
var _endpoints = require("./icons/endpoints");
var _endpoint_policies = require("./icons/endpoint_policies");
var _event_filters = require("./icons/event_filters");
var _exception_lists = require("./icons/exception_lists");
var _host_isolation = require("./icons/host_isolation");
var _siem_rules = require("./icons/siem_rules");
var _trusted_applications = require("./icons/trusted_applications");
var _host_isolation_exceptions_api_client = require("./pages/host_isolation_exceptions/host_isolation_exceptions_api_client");
var _experimental_features_service = require("../common/experimental_features_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const categories = [{
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.siem', {
    defaultMessage: 'SIEM'
  }),
  linkIds: [_constants.SecurityPageName.rules, _constants.SecurityPageName.exceptions]
}, {
  label: _i18n.i18n.translate('xpack.securitySolution.appLinks.category.endpoints', {
    defaultMessage: 'ENDPOINTS'
  }),
  linkIds: [_constants.SecurityPageName.endpoints, _constants.SecurityPageName.policies, _constants.SecurityPageName.trustedApps, _constants.SecurityPageName.eventFilters, _constants.SecurityPageName.hostIsolationExceptions, _constants.SecurityPageName.blocklist, _constants.SecurityPageName.responseActionsHistory]
}, ..._links.manageCategories];
const links = {
  id: _constants.SecurityPageName.administration,
  title: _translations.MANAGE,
  path: _constants.MANAGE_PATH,
  skipUrlState: true,
  hideTimeline: true,
  globalNavPosition: 8,
  capabilities: [`${_constants.SERVER_APP_ID}.show`],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.manage', {
    defaultMessage: 'Manage'
  })],
  categories,
  links: [{
    id: _constants.SecurityPageName.rules,
    title: _translations.RULES,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.rulesDescription', {
      defaultMessage: "Create and manage rules to check for suspicious source events, and create alerts when a rule's conditions are met."
    }),
    landingIcon: _siem_rules.IconSiemRules,
    path: _constants.RULES_PATH,
    globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.rules', {
      defaultMessage: 'Rules'
    })],
    links: [{
      id: _constants.SecurityPageName.rulesCreate,
      title: _translations.CREATE_NEW_RULE,
      path: _constants.RULES_CREATE_PATH,
      skipUrlState: true,
      hideTimeline: true
    }]
  }, {
    id: _constants.SecurityPageName.exceptions,
    title: _translations.EXCEPTIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.exceptionsDescription', {
      defaultMessage: 'Create and manage shared exception lists to prevent the creation of unwanted alerts.'
    }),
    landingIcon: _exception_lists.IconExceptionLists,
    path: _constants.EXCEPTIONS_PATH,
    skipUrlState: true,
    hideTimeline: true,
    globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.exceptions', {
      defaultMessage: 'Exception lists'
    })]
  }, {
    id: _constants.SecurityPageName.endpoints,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.endpointsDescription', {
      defaultMessage: 'Hosts running Elastic Defend.'
    }),
    landingIcon: _endpoints.IconEndpoints,
    title: _translations.ENDPOINTS,
    path: _constants.ENDPOINTS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.policies,
    title: _translations.POLICIES,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.policiesDescription', {
      defaultMessage: 'Use policies to customize endpoint and cloud workload protections and other configurations.'
    }),
    landingIcon: _endpoint_policies.IconEndpointPolicies,
    path: _constants.POLICIES_PATH,
    skipUrlState: true,
    hideTimeline: true,
    experimentalKey: 'policyListEnabled'
  }, {
    id: _constants.SecurityPageName.trustedApps,
    title: _translations.TRUSTED_APPLICATIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.trustedApplicationsDescription', {
      defaultMessage: 'Improve performance or alleviate conflicts with other applications running on your hosts.'
    }),
    landingIcon: _trusted_applications.IconTrustedApplications,
    path: _constants.TRUSTED_APPS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.eventFilters,
    title: _translations.EVENT_FILTERS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.eventFiltersDescription', {
      defaultMessage: 'Exclude high volume or unwanted events being written into Elasticsearch.'
    }),
    landingIcon: _event_filters.IconEventFilters,
    path: _constants.EVENT_FILTERS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.hostIsolationExceptions,
    title: _translations.HOST_ISOLATION_EXCEPTIONS,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.hostIsolationDescription', {
      defaultMessage: 'Allow isolated hosts to communicate with specific IPs.'
    }),
    landingIcon: _host_isolation.IconHostIsolation,
    path: _constants.HOST_ISOLATION_EXCEPTIONS_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.blocklist,
    title: _translations.BLOCKLIST,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.blocklistDescription', {
      defaultMessage: 'Exclude unwanted applications from running on your hosts.'
    }),
    landingIcon: _blocklist.IconBlocklist,
    path: _constants.BLOCKLIST_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, {
    id: _constants.SecurityPageName.responseActionsHistory,
    title: _translations.RESPONSE_ACTIONS_HISTORY,
    description: _i18n.i18n.translate('xpack.securitySolution.appLinks.actionHistoryDescription', {
      defaultMessage: 'View the history of response actions performed on hosts.'
    }),
    landingIcon: _action_history.IconActionHistory,
    path: _constants.RESPONSE_ACTIONS_HISTORY_PATH,
    skipUrlState: true,
    hideTimeline: true
  }, _links.manageLinks, _links2.manageLinks]
};
exports.links = links;
const excludeLinks = linkIds => {
  var _links$links;
  return {
    ...links,
    links: (_links$links = links.links) === null || _links$links === void 0 ? void 0 : _links$links.filter(link => !linkIds.includes(link.id))
  };
};
const getManagementFilteredLinks = async (core, plugins) => {
  var _plugins$fleet;
  const fleetAuthz = (_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : _plugins$fleet.authz;
  const {
    endpointRbacEnabled,
    endpointRbacV1Enabled
  } = _experimental_features_service.ExperimentalFeaturesService.get();
  const isEndpointRbacEnabled = endpointRbacEnabled || endpointRbacV1Enabled;
  const linksToExclude = [];
  const currentUser = await plugins.security.authc.getCurrentUser();
  const isPlatinumPlus = _use_license.licenseService.isPlatinumPlus();
  let hasHostIsolationExceptions = isPlatinumPlus;

  // If not Platinum+ license and user has read permissions to security solution
  // then check if Host Isolation Exceptions exist.
  // *** IT IS IMPORTANT *** that  this HTTP call only be made if the user has access to the
  // Lists plugin, else non-security solution users, especially when license is not Platinum,
  // may see failed HTTP requests in the browser console. This is the reason that
  // `hasKibanaPrivilege()` is used below.
  if (currentUser && !isPlatinumPlus && fleetAuthz && (0, _authz.hasKibanaPrivilege)(fleetAuthz, isEndpointRbacEnabled, currentUser.roles.includes('superuser'), 'readHostIsolationExceptions')) {
    hasHostIsolationExceptions = await (0, _check_artifact_has_data.checkArtifactHasData)(_host_isolation_exceptions_api_client.HostIsolationExceptionsApiClient.getInstance(core.http));
  }
  const {
    canReadActionsLogManagement,
    canReadHostIsolationExceptions,
    canReadEndpointList,
    canReadTrustedApplications,
    canReadEventFilters,
    canReadBlocklist,
    canReadPolicyManagement
  } = fleetAuthz && currentUser ? (0, _authz2.calculateEndpointAuthz)(_use_license.licenseService, fleetAuthz, currentUser.roles, isEndpointRbacEnabled, hasHostIsolationExceptions) : (0, _authz2.getEndpointAuthzInitialState)();
  if (!canReadEndpointList) {
    linksToExclude.push(_constants.SecurityPageName.endpoints);
  }
  if (!canReadPolicyManagement) {
    linksToExclude.push(_constants.SecurityPageName.policies);
  }
  if (!canReadActionsLogManagement) {
    linksToExclude.push(_constants.SecurityPageName.responseActionsHistory);
  }
  if (!canReadHostIsolationExceptions) {
    linksToExclude.push(_constants.SecurityPageName.hostIsolationExceptions);
  }
  if (!canReadTrustedApplications) {
    linksToExclude.push(_constants.SecurityPageName.trustedApps);
  }
  if (!canReadEventFilters) {
    linksToExclude.push(_constants.SecurityPageName.eventFilters);
  }
  if (!canReadBlocklist) {
    linksToExclude.push(_constants.SecurityPageName.blocklist);
  }
  return excludeLinks(linksToExclude);
};
exports.getManagementFilteredLinks = getManagementFilteredLinks;