"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetEndpointPolicyResponse = useGetEndpointPolicyResponse;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetEndpointPolicyResponse(selectedEndpoint, customQueryOptions) {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)(['getEndpointPolicyResponse', selectedEndpoint], () => {
    return http.get(_constants.BASE_POLICY_RESPONSE_ROUTE, {
      query: {
        agentId: selectedEndpoint
      }
    });
  }, customQueryOptions);
}