"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedRoute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _no_privileges = require("../../../common/components/no_privileges");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _no_permissons = require("../no_permissons");
var _constants = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PrivilegedRoute = /*#__PURE__*/(0, _react.memo)(({
  component,
  hasPrivilege,
  path
}) => {
  const isEndpointRbacEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointRbacEnabled');
  const isEndpointRbacV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointRbacV1Enabled');
  const docLinkSelector = docLinks => docLinks.securitySolution.privileges;
  let componentToRender = component;
  if (!hasPrivilege) {
    const shouldUseMissingPrivilegesScreen = isEndpointRbacEnabled || isEndpointRbacV1Enabled && path === _constants.MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH;
    componentToRender = shouldUseMissingPrivilegesScreen ? () => /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivilegesPage, {
      docLinkSelector: docLinkSelector
    }) : _no_permissons.NoPermissions;
  }
  return /*#__PURE__*/_react.default.createElement(_public.Route, {
    path: path,
    component: componentToRender
  });
});
exports.PrivilegedRoute = PrivilegedRoute;
PrivilegedRoute.displayName = 'PrivilegedRoute';