"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.descriptions = exports.PolicyResponseActionFormatter = exports.LINUX_DEADLOCK_MESSAGE = void 0;
exports.formatResponse = formatResponse;
exports.policyResponseTitles = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _types = require("../../../../common/endpoint/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const policyResponseSections = Object.freeze(new Map([['logging', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.logging', {
  defaultMessage: 'Logging'
})], ['streaming', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.streaming', {
  defaultMessage: 'Streaming'
})], ['malware', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.malware', {
  defaultMessage: 'Malware'
})], ['events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.events', {
  defaultMessage: 'Events'
})], ['memory_protection', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.memory_protection', {
  defaultMessage: 'Memory Threat'
})], ['behavior_protection', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.behavior_protection', {
  defaultMessage: 'Malicious Behavior'
})]]));

/**
 * Maps a server provided value to corresponding i18n'd string.
 */
function formatResponse(responseString) {
  if (policyResponseSections.has(responseString)) {
    return policyResponseSections.get(responseString);
  }

  // Its possible for the UI to receive an Action name that it does not yet have a translation,
  // thus we generate a label for it here by making it more user fiendly
  policyResponseSections.set(responseString, responseString.replace(/_/g, ' ').replace(/\b(\w)/g, m => m.toUpperCase()));
  return policyResponseSections.get(responseString);
}
const policyResponseTitles = Object.freeze(new Map([['configure_dns_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_dns_events', {
  defaultMessage: 'Configure DNS Events'
})], ['configure_elasticsearch_connection', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_elasticsearch_connection', {
  defaultMessage: 'Configure Elasticsearch Connection'
})], ['configure_file_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_file_events', {
  defaultMessage: 'Configure File Events'
})], ['configure_imageload_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_imageload_events', {
  defaultMessage: 'Configure Image Load Events'
})], ['configure_kernel', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_kernel', {
  defaultMessage: 'Configure Kernel'
})], ['configure_logging', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_logging', {
  defaultMessage: 'Configure Logging'
})], ['configure_malware', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_malware', {
  defaultMessage: 'Configure Malware'
})], ['configure_network_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_network_events', {
  defaultMessage: 'Configure Network Events'
})], ['configure_process_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_process_events', {
  defaultMessage: 'Configure Process Events'
})], ['configure_registry_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_registry_events', {
  defaultMessage: 'Configure Registry Events'
})], ['configure_security_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.configure_security_events', {
  defaultMessage: 'Configure Security Events'
})], ['connect_kernel', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.connect_kernel', {
  defaultMessage: 'Connect Kernel'
})], ['detect_async_image_load_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.detect_async_image_load_events', {
  defaultMessage: 'Detect Async Image Load Events'
})], ['detect_file_open_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.detect_file_open_events', {
  defaultMessage: 'Detect File Open Events'
})], ['detect_file_write_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.detect_file_write_events', {
  defaultMessage: 'Detect File Write Events'
})], ['detect_network_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.detect_network_events', {
  defaultMessage: 'Detect Network Events'
})], ['detect_process_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.detect_process_events', {
  defaultMessage: 'Detect Process Events'
})], ['detect_registry_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.detect_registry_events', {
  defaultMessage: 'Detect Registry Events'
})], ['detect_sync_image_load_events', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.detect_sync_image_load_events', {
  defaultMessage: 'Detect Sync Image Load Events'
})], ['download_global_artifacts', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.download_global_artifacts', {
  defaultMessage: 'Download Global Artifacts'
})], ['download_user_artifacts', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.download_user_artifacts', {
  defaultMessage: 'Download User Artifacts'
})], ['load_config', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.load_config', {
  defaultMessage: 'Load Config'
})], ['load_malware_model', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.load_malware_model', {
  defaultMessage: 'Load Malware Model'
})], ['read_elasticsearch_config', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.read_elasticsearch_config', {
  defaultMessage: 'Read Elasticsearch Config'
})], ['read_events_config', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.read_events_config', {
  defaultMessage: 'Read Events Config'
})], ['read_kernel_config', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.read_kernel_config', {
  defaultMessage: 'Read Kernel Config'
})], ['read_logging_config', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.read_logging_config', {
  defaultMessage: 'Read Logging Config'
})], ['read_malware_config', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.read_malware_config', {
  defaultMessage: 'Read Malware Config'
})], ['workflow', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.workflow', {
  defaultMessage: 'Workflow'
})], ['full_disk_access', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.full_disk_access', {
  defaultMessage: 'Full Disk Access'
})], ['macos_system_ext', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.macos_system_ext', {
  defaultMessage: 'Permissions required'
})], ['linux_deadlock', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.linux_deadlock', {
  defaultMessage: 'Disabled to avoid potential system deadlock'
})]]));
exports.policyResponseTitles = policyResponseTitles;
const policyResponseStatuses = Object.freeze(new Map([[_types.HostPolicyResponseActionStatus.success, _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.success', {
  defaultMessage: 'Success'
})], [_types.HostPolicyResponseActionStatus.warning, _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.warning', {
  defaultMessage: 'Warning'
})], [_types.HostPolicyResponseActionStatus.failure, _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.failed', {
  defaultMessage: 'Failed'
})], [_types.HostPolicyResponseActionStatus.unsupported, _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.unsupported', {
  defaultMessage: 'Unsupported'
})]]));
const descriptions = Object.freeze(new Map([['full_disk_access', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.description.full_disk_access', {
  defaultMessage: 'You must enable full disk access for Elastic Endpoint on your machine.'
})], ['macos_system_ext', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.description.macos_system_ext', {
  defaultMessage: 'You must enable the Mac system extension for Elastic Endpoint on your machine.'
})], ['linux_deadlock', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.description.linux_deadlock', {
  defaultMessage: 'Malware protection was disabled to avoid a potential system deadlock. To resolve this issue, the file systems causing this need to be identified in integration policy advanced settings (linux.advanced.fanotify.ignored_filesystems). Learn more in our'
})]]));
exports.descriptions = descriptions;
const linkTexts = Object.freeze(new Map([['full_disk_access', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.link.text.full_disk_access', {
  defaultMessage: ' Learn more.'
})], ['macos_system_ext', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.link.text.macos_system_ext', {
  defaultMessage: ' Learn more.'
})], ['linux_deadlock', _i18n.i18n.translate('xpack.securitySolution.endpoint.details.policyResponse.link.text.linux_deadlock', {
  defaultMessage: ' troubleshooting docs.'
})]]));
const LINUX_DEADLOCK_MESSAGE = 'Disabled due to potential system deadlock';
exports.LINUX_DEADLOCK_MESSAGE = LINUX_DEADLOCK_MESSAGE;
const LINUX_DEADLOCK_ACTION_ERRORS = new Set(['load_malware_model', 'configure_malware']);
function isMacosFullDiskAccessError(os, policyAction) {
  return os === 'macos' && policyAction.name === 'full_disk_access';
}
function isMacosSystemExtensionError(os, policyAction) {
  return os === 'macos' && policyAction.name === 'connect_kernel' && policyAction.status === _types.HostPolicyResponseActionStatus.failure;
}
function isLinuxDeadlockError(os, policyAction) {
  return os === 'linux' && LINUX_DEADLOCK_ACTION_ERRORS.has(policyAction.name) && policyAction.message === LINUX_DEADLOCK_MESSAGE;
}
class PolicyResponseActionFormatter {
  constructor(policyResponseAppliedAction, docLinks, os = '') {
    var _policyResponseTitles;
    (0, _defineProperty2.default)(this, "key", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "description", void 0);
    (0, _defineProperty2.default)(this, "hasError", void 0);
    (0, _defineProperty2.default)(this, "errorTitle", void 0);
    (0, _defineProperty2.default)(this, "errorDescription", void 0);
    (0, _defineProperty2.default)(this, "status", void 0);
    (0, _defineProperty2.default)(this, "linkText", void 0);
    this.policyResponseAppliedAction = policyResponseAppliedAction;
    this.docLinks = docLinks;
    this.os = os;
    this.key = policyResponseAppliedAction.name;
    this.title = (_policyResponseTitles = policyResponseTitles.get(this.errorKey || this.key)) !== null && _policyResponseTitles !== void 0 ? _policyResponseTitles : this.key.replace(/_/g, ' ').replace(/\b(\w)/g, m => m.toUpperCase());
    this.hasError = policyResponseAppliedAction.status === _types.HostPolicyResponseActionStatus.failure || policyResponseAppliedAction.status === _types.HostPolicyResponseActionStatus.warning;
    this.description = descriptions.get(this.key) || policyResponseAppliedAction.message;
    this.errorDescription = descriptions.get(this.errorKey || this.key) || this.policyResponseAppliedAction.message;
    this.errorTitle = this.errorDescription ? this.title : policyResponseAppliedAction.name;
    this.status = policyResponseStatuses.get(policyResponseAppliedAction.status);
    this.linkText = linkTexts.get(this.errorKey || this.key);
  }
  get linkUrl() {
    return this.docLinks[this.errorKey];
  }
  get isGeneric() {
    if (isMacosFullDiskAccessError(this.os, this.policyResponseAppliedAction) || isMacosSystemExtensionError(this.os, this.policyResponseAppliedAction) || isLinuxDeadlockError(this.os, this.policyResponseAppliedAction)) {
      return true;
    }
    return false;
  }
  get errorKey() {
    if (isMacosSystemExtensionError(this.os, this.policyResponseAppliedAction)) {
      return 'macos_system_ext';
    }
    if (isLinuxDeadlockError(this.os, this.policyResponseAppliedAction)) {
      return 'linux_deadlock';
    }
    return this.policyResponseAppliedAction.name;
  }
}
exports.PolicyResponseActionFormatter = PolicyResponseActionFormatter;