"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyResponseActionItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiCallout = (0, _styledComponents.default)(_eui.EuiCallOut)`
  padding: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const StyledEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  white-space: break-spaces;
  text-align: left;
  line-height: inherit;
`;
/**
 * A policy response action item
 */
const PolicyResponseActionItem = /*#__PURE__*/(0, _react.memo)(({
  policyResponseActionFormatter
}) => {
  return policyResponseActionFormatter.hasError ? /*#__PURE__*/_react.default.createElement(StyledEuiCallout, {
    title: policyResponseActionFormatter.errorTitle,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "endpointPolicyResponseErrorCallOut"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: "s",
    "data-test-subj": "endpointPolicyResponseMessage"
  }, policyResponseActionFormatter.errorDescription, policyResponseActionFormatter.linkText && policyResponseActionFormatter.linkUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: policyResponseActionFormatter.linkUrl,
    "data-test-subj": "endpointPolicyResponseErrorCallOutLink"
  }, policyResponseActionFormatter.linkText))) : /*#__PURE__*/_react.default.createElement(StyledEuiText, {
    size: "xs",
    "data-test-subj": "endpointPolicyResponseMessage"
  }, policyResponseActionFormatter.description || policyResponseActionFormatter.title);
});
exports.PolicyResponseActionItem = PolicyResponseActionItem;
PolicyResponseActionItem.displayName = 'PolicyResponseActionItem';