"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyResponse = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../common/lib/kibana");
var _types = require("../../../../common/endpoint/types");
var _policy_response_friendly_names = require("./policy_response_friendly_names");
var _policy_response_action_item = require("./policy_response_action_item");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Most of them are needed in order to display large react nodes (PolicyResponseActionItem) in child levels.
const StyledEuiTreeView = (0, _styledComponents.default)(_eui.EuiTreeView)`
  .policy-response-action-item-expanded {
    height: auto;
    padding-top: ${({
  theme
}) => theme.eui.euiSizeS};
    padding-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
    .euiTreeView__nodeLabel {
      width: 100%;
    }
  }
  .policyResponseStatusHealth {
    padding-top: 5px;
  }
  .euiTreeView__node--expanded {
    max-height: none !important;
    .policy-response-action-expanded + div {
      .euiTreeView__node {
        // When response action item displays a callout, this needs to be overwritten to remove the default max height of EuiTreeView
        max-height: none !important;
      }
    }
  }
  .euiTreeView__node {
    max-height: none !important;
    .euiNotificationBadge {
      margin-right: 5px;
    }
    .euiTreeView__nodeLabel {
      .euiText {
        font-size: ${({
  theme
}) => theme.eui.euiFontSize};
      }
    }
  }
`;
/**
 * A policy response is returned by the endpoint and shown in the host details after a user modifies a policy
 */
const PolicyResponse = /*#__PURE__*/(0, _react.memo)(({
  hostOs,
  policyResponseConfig,
  policyResponseActions,
  policyResponseAttentionCount
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const getEntryIcon = (0, _react.useCallback)((status, unsuccessCounts) => status === _types.HostPolicyResponseActionStatus.success ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success",
    "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
    className: "policyResponseStatusHealth"
  }) : status === _types.HostPolicyResponseActionStatus.unsupported ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
    className: "policyResponseStatusHealth"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    "data-test-subj": "endpointPolicyResponseStatusAttentionHealth"
  }, unsuccessCounts), []);
  const getConcernedActions = (0, _react.useCallback)(concernedActions => {
    return concernedActions.map(actionKey => {
      const action = policyResponseActions.find(currentAction => currentAction.name === actionKey);
      const policyResponseActionFormatter = new _policy_response_friendly_names.PolicyResponseActionFormatter(action || {}, docLinks.links.securitySolution.policyResponseTroubleshooting, hostOs);
      return {
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          color: action.status !== _types.HostPolicyResponseActionStatus.success && action.status !== _types.HostPolicyResponseActionStatus.unsupported ? 'danger' : 'default',
          "data-test-subj": "endpointPolicyResponseAction"
        }, policyResponseActionFormatter.title),
        id: actionKey,
        className: action.status !== _types.HostPolicyResponseActionStatus.success && action.status !== _types.HostPolicyResponseActionStatus.unsupported ? 'policy-response-action-expanded' : '',
        icon: getEntryIcon(action.status, action.status !== _types.HostPolicyResponseActionStatus.success ? 1 : 0),
        children: [{
          label: /*#__PURE__*/_react.default.createElement(_policy_response_action_item.PolicyResponseActionItem, {
            policyResponseActionFormatter: policyResponseActionFormatter
          }),
          id: `action_message_${actionKey}`,
          isExpanded: true,
          className: 'policy-response-action-item-expanded'
        }]
      };
    });
  }, [docLinks.links.securitySolution.policyResponseTroubleshooting, getEntryIcon, policyResponseActions, hostOs]);
  const getResponseConfigs = (0, _react.useCallback)(() => Object.entries(policyResponseConfig).map(([key, val]) => {
    const attentionCount = policyResponseAttentionCount.get(key);
    return {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: attentionCount ? 'danger' : 'default',
        size: "s",
        "data-test-subj": "endpointPolicyResponseConfig"
      }, (0, _policy_response_friendly_names.formatResponse)(key)),
      id: key,
      icon: attentionCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": "endpointPolicyResponseStatusAttentionHealth"
      }, attentionCount) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: "success",
        "data-test-subj": "endpointPolicyResponseStatusSuccessHealth",
        className: "policyResponseStatusHealth"
      }),
      children: getConcernedActions(val.concerned_actions)
    };
  }), [getConcernedActions, policyResponseAttentionCount, policyResponseConfig]);
  const generateTreeView = (0, _react.useCallback)(() => {
    let policyTotalErrors = 0;
    for (const count of policyResponseAttentionCount.values()) {
      policyTotalErrors += count;
    }
    return [{
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: policyTotalErrors ? 'danger' : 'default',
        size: "s",
        "data-test-subj": "endpointPolicyResponseTitle"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policyResponse.title",
        defaultMessage: "Policy Response"
      })),
      id: 'policyResponse',
      icon: policyTotalErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": "endpointPolicyResponseStatusHealth"
      }, policyTotalErrors) : undefined,
      children: getResponseConfigs()
    }];
  }, [getResponseConfigs, policyResponseAttentionCount]);
  const generatedTreeView = generateTreeView();
  return /*#__PURE__*/_react.default.createElement(StyledEuiTreeView, {
    items: generatedTreeView,
    showExpansionArrows: true,
    "aria-label": "policyResponseTreeView",
    "aria-labelledby": "policyResponseTreeView"
  });
});
exports.PolicyResponse = PolicyResponse;
PolicyResponse.displayName = 'PolicyResponse';