"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingEncryptionKeyCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MissingEncryptionKeyCallout = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    data: encryptionKeyState
  } = (0, _hooks.useGetActionState)();
  const [calloutDismiss, setCalloutDismiss] = (0, _react.useState)(false);
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const onClickDismissButton = (0, _react.useCallback)(() => setCalloutDismiss(true), []);
  if (!encryptionKeyState) {
    return null;
  }
  if (calloutDismiss || encryptionKeyState.data.canEncrypt === true) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "iInCircle",
    "data-test-subj": "missingEncryptionKeyCallout",
    title: _i18n.i18n.translate('xpack.securitySolution.responder.missingEncryptionKey.callout.title', {
      defaultMessage: 'Set up encryption key'
    })
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responder.missingEncryptionKey.callout.body",
    defaultMessage: "We recommend encryption keys be configured to protect sensitive information and make your environment more secure. Without encryption keys configured, some features may not perform as intended. {viewMore}.",
    values: {
      viewMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.kibana.secureSavedObject,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.responder.missingEncryptionKey.docsLink",
        defaultMessage: "View more information"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClickDismissButton,
    color: "warning",
    "data-test-subj": "dismissEncryptionKeyCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.responder.missingEncryptionKey.callout.dismissButton.label",
    defaultMessage: "Dismiss"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
});
exports.MissingEncryptionKeyCallout = MissingEncryptionKeyCallout;
MissingEncryptionKeyCallout.displayName = 'MissingEncryptionKeyCallout';