"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObjectContent = exports.FormattedError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _coreHttpBrowser = require("@kbn/core-http-browser");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObjectContent = /*#__PURE__*/(0, _react.memo)(({
  data
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, Object.entries(data).map(([key, value]) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: key,
      className: "eui-textBreakAll"
    }, /*#__PURE__*/_react.default.createElement("strong", null, key), ': ', value);
  }));
});
exports.ObjectContent = ObjectContent;
ObjectContent.displayName = 'ObjectContent';
/**
 * A general component for formatting errors. Recognizes different types of errors and displays
 * their information.
 */
const FormattedError = /*#__PURE__*/(0, _react.memo)(({
  error,
  'data-test-subj': dataTestSubj
}) => {
  return (0, _react.useMemo)(() => {
    let content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error.message);
    if ((0, _coreHttpBrowser.isHttpFetchError)(error)) {
      var _error$response, _error$response2;
      content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, `${(_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status}: ${(_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.statusText}`), error.body && /*#__PURE__*/_react.default.createElement(ObjectContent, {
        data: error.body
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": dataTestSubj
    }, content);
  }, [dataTestSubj, error]);
});
exports.FormattedError = FormattedError;
FormattedError.displayName = 'FormattedError';